"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyntheticsAvailabilityIndicatorTypeForm = SyntheticsAvailabilityIndicatorTypeForm;
exports.getGroupByCardinalityFilters = void 0;
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_create_data_view = require("../../../../../hooks/use_create_data_view");
var _format_filters = require("../../../helpers/format_filters");
var _data_preview_chart = require("../../common/data_preview_chart");
var _group_by_cardinality = require("../../common/group_by_cardinality");
var _query_builder = require("../../common/query_builder");
var _index_selection = require("../custom_common/index_selection");
var _field_selector = require("../synthetics_common/field_selector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_edit/components/indicator_section/synthetics_availability/synthetics_availability_indicator_type_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SyntheticsAvailabilityIndicatorTypeForm() {
  const {
    watch,
    setValue,
    getValues
  } = (0, _reactHookForm.useFormContext)();
  const dataViewId = watch(_index_selection.DATA_VIEW_FIELD);
  const [monitorIds = [], projects = [], tags = [], index, globalFilters] = watch(['indicator.params.monitorIds', 'indicator.params.projects', 'indicator.params.tags', 'indicator.params.index', 'indicator.params.filter']);
  const {
    dataView
  } = (0, _use_create_data_view.useCreateDataView)({
    indexPatternString: index,
    dataViewId
  });
  const filters = {
    monitorIds: monitorIds.map(id => id.value).filter(id => id !== _sloSchema.ALL_VALUE),
    projects: projects.map(project => project.value).filter(id => id !== _sloSchema.ALL_VALUE),
    tags: tags.map(tag => tag.value).filter(id => id !== _sloSchema.ALL_VALUE)
  };
  const groupByCardinalityFilters = getGroupByCardinalityFilters(filters.monitorIds, filters.projects, filters.tags);
  const allFilters = (0, _format_filters.formatAllFilters)(globalFilters, groupByCardinalityFilters);
  const currentMonitors = getValues('indicator.params.monitorIds');
  (0, _react.useEffect)(() => {
    if (!currentMonitors || !currentMonitors.length) {
      setValue('indicator.params.monitorIds', [{
        value: '*',
        label: 'All'
      }]);
    }
  }, [currentMonitors, setValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, {
    required: true,
    allowAllOption: true,
    label: _i18n.i18n.translate('xpack.slo.sloEdit.syntheticsAvailability.monitor', {
      defaultMessage: 'Monitor name'
    }),
    placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.syntheticsAvailability.monitor.placeholder', {
      defaultMessage: 'Select the Synthetics monitor or choose all'
    }),
    fieldName: "monitorIds",
    name: "indicator.params.monitorIds",
    filters: filters,
    dataTestSubj: "syntheticsAvailabilityMonitorSelector",
    tooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.syntheticsAvailability.monitor.tooltip', {
        defaultMessage: 'This is the monitor or monitors part of this SLO. Select "*" to group by project, tag, or location'
      }),
      position: "top",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 13
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, {
    allowAllOption: true,
    label: _i18n.i18n.translate('xpack.slo.sloEdit.syntheticsAvailability.project', {
      defaultMessage: 'Project'
    }),
    placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.syntheticsAvailability.project.placeholder', {
      defaultMessage: 'Select the project'
    }),
    fieldName: "projects",
    name: "indicator.params.projects",
    filters: filters,
    dataTestSubj: "syntheticsAvailabilityProjectSelector",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, {
    label: _i18n.i18n.translate('xpack.slo.sloEdit.syntheticsAvailability.tags', {
      defaultMessage: 'Tags'
    }),
    placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.syntheticsAvailability.tags.placeholder', {
      defaultMessage: 'Select tags'
    }),
    fieldName: "tags",
    name: "indicator.params.tags",
    filters: filters,
    dataTestSubj: "syntheticsAvailabilityTagsSelector",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_query_builder.QueryBuilder, {
    dataTestSubj: "syntheticsAvailabilityFilterInput",
    dataView: dataView,
    label: _i18n.i18n.translate('xpack.slo.sloEdit.syntheticsAvailability.filter', {
      defaultMessage: 'Query filter'
    }),
    name: "indicator.params.filter",
    placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.syntheticsAvailability.filter.placeholder', {
      defaultMessage: 'Custom filter to apply on the index'
    }),
    tooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.synthetics.filter.tooltip', {
        defaultMessage: 'This KQL query is used to filter the Synthetics checks on some relevant criteria for this SLO.'
      }),
      position: "top",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 15
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_group_by_cardinality.GroupByCardinality, {
    titleAppend: _i18n.i18n.translate('xpack.slo.sloEdit.syntheticsAvailability.warning', {
      defaultMessage: 'Synthetics availability SLIs are automatically grouped by monitor and location.'
    }),
    customFilters: allFilters,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_data_preview_chart.DataPreviewChart, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 7
    }
  }));
}
const getGroupByCardinalityFilters = (monitorIds, projects, tags) => {
  const monitorIdFilters = monitorIds.length ? {
    meta: {
      disabled: false,
      negate: false,
      alias: null,
      key: 'monitor.id',
      params: monitorIds,
      type: 'phrases'
    },
    $state: {
      store: _esQuery.FilterStateStore.APP_STATE
    },
    query: {
      bool: {
        minimum_should_match: 1,
        should: monitorIds.map(id => ({
          match_phrase: {
            'monitor.id': id
          }
        }))
      }
    }
  } : null;
  const projectFilters = projects.length ? {
    meta: {
      disabled: false,
      negate: false,
      alias: null,
      key: 'monitor.project.id',
      params: projects,
      type: 'phrases'
    },
    $state: {
      store: _esQuery.FilterStateStore.APP_STATE
    },
    query: {
      bool: {
        minimum_should_match: 1,
        should: projects.map(id => ({
          match_phrase: {
            'monitor.project.id': id
          }
        }))
      }
    }
  } : null;
  const tagFilters = tags.length ? {
    meta: {
      disabled: false,
      negate: false,
      alias: null,
      key: 'tags',
      params: tags,
      type: 'phrases'
    },
    $state: {
      store: _esQuery.FilterStateStore.APP_STATE
    },
    query: {
      bool: {
        minimum_should_match: 1,
        should: tags.map(tag => ({
          match_phrase: {
            tags: tag
          }
        }))
      }
    }
  } : null;
  return [monitorIdFilters, projectFilters, tagFilters].filter(value => !!value);
};
exports.getGroupByCardinalityFilters = getGroupByCardinalityFilters;