"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WideChart = WideChart;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _public = require("@kbn/charts-plugin/public");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/observability-plugin/public");
var _duration = require("../../../utils/slo/duration");
var _use_kibana = require("../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_details/components/wide_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function WideChart({
  chart,
  data,
  id,
  isLoading,
  state,
  onBrushed,
  slo
}) {
  const {
    charts,
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const baseTheme = charts.theme.useChartsBaseTheme();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const dateFormat = uiSettings.get('dateFormat');
  const percentFormat = uiSettings.get('format:percent:defaultPattern');
  const color = state === 'error' ? euiTheme.colors.danger : euiTheme.colors.success;
  const ChartComponent = chart === 'area' ? _charts.AreaSeries : _charts.LineSeries;
  const {
    ObservabilityAnnotations,
    annotations,
    onAnnotationClick,
    wrapOnBrushEnd
  } = (0, _public2.useAnnotations)({
    slo,
    domain: {
      min: 'now-30d',
      max: 'now'
    }
  });
  const chartRef = (0, _react.useRef)(null);
  const handleCursorUpdate = (0, _public.useActiveCursor)(charts.activeCursor, chartRef, {
    isDateHistogram: true
  });
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
      size: "m",
      "data-test-subj": "wideChartLoading",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 200,
      width: '100%'
    },
    ref: chartRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ObservabilityAnnotations, {
    annotations: annotations,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: {
      chartMargins: {
        top: 30
      }
    },
    baseTheme: baseTheme,
    showLegend: false,
    noResults: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "visualizeApp",
      size: "l",
      color: "subdued",
      title: _i18n.i18n.translate('xpack.slo.wideChart.euiIcon.noResultsLabel', {
        defaultMessage: 'no results'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 11
      }
    }),
    onPointerUpdate: handleCursorUpdate,
    externalPointerEvents: {
      tooltip: {
        visible: true
      }
    },
    pointerUpdateDebounce: 0,
    pointerUpdateTrigger: 'x',
    locale: _i18n.i18n.getLocale(),
    onBrushEnd: wrapOnBrushEnd(brushArea => {
      onBrushed === null || onBrushed === void 0 ? void 0 : onBrushed((0, _duration.getBrushTimeBounds)(brushArea));
    }),
    onAnnotationClick: onAnnotationClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: d => (0, _moment.default)(d).format(dateFormat),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left",
    ticks: 4,
    position: _charts.Position.Left,
    tickFormat: d => (0, _numeral.default)(d).format(percentFormat),
    domain: {
      fit: true,
      min: NaN,
      max: NaN
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(ChartComponent, {
    color: color,
    data: data,
    fit: _charts.Fit.Nearest,
    id: id,
    lineSeriesStyle: {
      line: {
        strokeWidth: 1
      },
      point: {
        visible: 'never'
      }
    },
    xAccessor: "key"
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yAccessors: ['value'],
    yScaleType: _charts.ScaleType.Linear,
    yNice: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }));
}