"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloRemoteCallout = SloRemoteCallout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _remote_slo_urls = require("../../../utils/slo/remote_slo_urls");
var _use_space = require("../../../hooks/use_space");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_details/components/slo_remote_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SloRemoteCallout({
  slo
}) {
  const spaceId = (0, _use_space.useSpace)();
  const sloDetailsUrl = (0, _remote_slo_urls.createRemoteSloDetailsUrl)(slo, spaceId);
  if (!slo.remote) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.slo.sloDetails.headerTitle.calloutMessage', {
      defaultMessage: 'Remote SLO'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloDetails.headerTitle.calloutDescription",
    defaultMessage: "This is a remote SLO which belongs to another Kibana instance. It is fetched from the remote cluster: {remoteName} with Kibana URL {kibanaUrl}.",
    values: {
      remoteName: /*#__PURE__*/_react.default.createElement("strong", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 35,
          columnNumber: 25
        }
      }, slo.remote.remoteName),
      kibanaUrl: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "sloSloRemoteCalloutLink",
        href: slo.remote.kibanaUrl,
        target: "_blank",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 37,
          columnNumber: 15
        }
      }, slo.remote.kibanaUrl)
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11yHeaderTitleLinkButtonButton",
    href: sloDetailsUrl,
    color: "primary",
    target: "_blank",
    iconType: "popout",
    iconSide: "right",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.slo.headerTitle.linkButtonButtonLabel', {
    defaultMessage: 'View remote SLO details'
  })));
}