"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderControl = HeaderControl;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _flyout = require("@kbn/response-ops-rule-form/flyout");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react = _interopRequireWildcard(require("react"));
var _paths = require("../../../../common/locators/paths");
var _action_modal = require("../../../context/action_modal");
var _use_fetch_rules_for_slo = require("../../../hooks/use_fetch_rules_for_slo");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_permissions = require("../../../hooks/use_permissions");
var _convert_sli_apm_params_to_apm_app_deeplink_url = require("../../../utils/slo/convert_sli_apm_params_to_apm_app_deeplink_url");
var _indicator = require("../../../utils/slo/indicator");
var _edit_burn_rate_rule_flyout = require("../../slos/components/common/edit_burn_rate_rule_flyout");
var _use_get_query_params = require("../hooks/use_get_query_params");
var _use_slo_actions = require("../hooks/use_slo_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_details/components/header_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function HeaderControl({
  slo
}) {
  var _rulesBySlo$slo$id, _slo$remote;
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const {
    application: {
      navigateToUrl,
      capabilities
    },
    http: {
      basePath
    },
    triggersActionsUi: {
      ruleTypeRegistry,
      actionTypeRegistry
    }
  } = services;
  const hasApmReadCapabilities = capabilities.apm.show;
  const {
    data: permissions
  } = (0, _use_permissions.usePermissions)();
  const {
    triggerAction
  } = (0, _action_modal.useActionModal)();
  const {
    isDeletingSlo,
    isResettingSlo,
    isEnablingSlo,
    isDisablingSlo,
    removeDeleteQueryParam,
    removeResetQueryParam,
    removeEnableQueryParam,
    removeDisableQueryParam
  } = (0, _use_get_query_params.useGetQueryParams)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [isRuleFlyoutVisible, setRuleFlyoutVisibility] = (0, _react.useState)(false);
  const [isEditRuleFlyoutOpen, setIsEditRuleFlyoutOpen] = (0, _react.useState)(false);
  const {
    data: rulesBySlo,
    refetchRules
  } = (0, _use_fetch_rules_for_slo.useFetchRulesForSlo)({
    sloIds: [slo.id]
  });
  const rules = (_rulesBySlo$slo$id = rulesBySlo === null || rulesBySlo === void 0 ? void 0 : rulesBySlo[slo.id]) !== null && _rulesBySlo$slo$id !== void 0 ? _rulesBySlo$slo$id : [];
  const handleActionsClick = () => setIsPopoverOpen(value => !value);
  const closePopover = () => setIsPopoverOpen(false);
  const navigate = (0, _react.useCallback)(url => setTimeout(() => navigateToUrl(url)), [navigateToUrl]);
  (0, _react.useEffect)(() => {
    if (isDeletingSlo) {
      triggerAction({
        type: 'delete',
        item: slo,
        onConfirm: () => {
          navigate(basePath.prepend(_paths.paths.slos));
        }
      });
      removeDeleteQueryParam();
    }
    if (isResettingSlo) {
      triggerAction({
        type: 'reset',
        item: slo
      });
      removeResetQueryParam();
    }
    if (isEnablingSlo) {
      triggerAction({
        type: 'enable',
        item: slo
      });
      removeEnableQueryParam();
    }
    if (isDisablingSlo) {
      triggerAction({
        type: 'disable',
        item: slo
      });
      removeDisableQueryParam();
    }
  });
  const onCloseRuleFlyout = () => {
    setRuleFlyoutVisibility(false);
  };
  const handleOpenRuleFlyout = () => {
    closePopover();
    setRuleFlyoutVisibility(true);
  };
  const {
    handleNavigateToRules,
    sloEditUrl,
    remoteDeleteUrl,
    remoteResetUrl,
    remoteEnableUrl,
    remoteDisableUrl
  } = (0, _use_slo_actions.useSloActions)({
    slo,
    rules,
    setIsEditRuleFlyoutOpen,
    setIsActionsPopoverOpen: setIsPopoverOpen
  });
  const handleNavigateToApm = () => {
    const url = (0, _convert_sli_apm_params_to_apm_app_deeplink_url.convertSliApmParamsToApmAppDeeplinkUrl)(slo);
    if (url) {
      navigateToUrl(basePath.prepend(url));
    }
  };
  const handleClone = () => {
    triggerAction({
      type: 'clone',
      item: slo
    });
  };
  const handleDelete = () => {
    if (!!remoteDeleteUrl) {
      window.open(remoteDeleteUrl, '_blank');
    } else {
      triggerAction({
        type: 'delete',
        item: slo,
        onConfirm: () => {
          navigate(basePath.prepend(_paths.paths.slos));
          setIsPopoverOpen(false);
        }
      });
      removeDeleteQueryParam();
    }
  };
  const handleReset = () => {
    if (!!remoteResetUrl) {
      window.open(remoteResetUrl, '_blank');
    } else {
      triggerAction({
        type: 'reset',
        item: slo,
        onConfirm: () => {
          setIsPopoverOpen(false);
        }
      });
      removeResetQueryParam();
    }
  };
  const handleEnable = () => {
    if (!!remoteEnableUrl) {
      window.open(remoteEnableUrl, '_blank');
    } else {
      triggerAction({
        type: 'enable',
        item: slo,
        onConfirm: () => {
          setIsPopoverOpen(false);
        }
      });
      removeEnableQueryParam();
    }
  };
  const handleDisable = () => {
    if (!!remoteDisableUrl) {
      window.open(remoteDisableUrl, '_blank');
    } else {
      triggerAction({
        type: 'disable',
        item: slo,
        onConfirm: () => {
          setIsPopoverOpen(false);
        }
      });
      removeDisableQueryParam();
    }
  };
  const isRemote = !!(slo !== null && slo !== void 0 && slo.remote);
  const hasUndefinedRemoteKibanaUrl = !!(slo !== null && slo !== void 0 && slo.remote) && (slo === null || slo === void 0 ? void 0 : (_slo$remote = slo.remote) === null || _slo$remote === void 0 ? void 0 : _slo$remote.kibanaUrl) === '';
  const showRemoteLinkIcon = isRemote ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "popout",
    size: "s",
    css: {
      marginLeft: '10px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 5
    }
  }) : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "sloDetailsHeaderControlPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "o11yHeaderControlActionsButton",
      fill: true,
      iconSide: "right",
      iconType: "arrowDown",
      iconSize: "s",
      onClick: handleActionsClick,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.slo.sloDetails.headerControl.actions', {
      defaultMessage: 'Actions'
    })),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "m",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "edit",
      disabled: !(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested) || hasUndefinedRemoteKibanaUrl,
      icon: "pencil",
      href: sloEditUrl,
      target: isRemote ? '_blank' : undefined,
      toolTipContent: hasUndefinedRemoteKibanaUrl ? NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL : '',
      "data-test-subj": "sloDetailsHeaderControlPopoverEdit",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.slo.sloDetails.headerControl.edit', {
      defaultMessage: 'Edit'
    }), showRemoteLinkIcon), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "createBurnRateRule",
      disabled: !(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested) || isRemote,
      icon: "bell",
      onClick: handleOpenRuleFlyout,
      "data-test-subj": "sloDetailsHeaderControlPopoverCreateRule",
      toolTipContent: isRemote ? NOT_AVAILABLE_FOR_REMOTE : '',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.slo.sloDetails.headerControl.createBurnRateRule', {
      defaultMessage: 'Create new alert rule'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "manageRules",
      disabled: !(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested) || hasUndefinedRemoteKibanaUrl,
      icon: "gear",
      onClick: handleNavigateToRules,
      "data-test-subj": "sloDetailsHeaderControlPopoverManageRules",
      toolTipContent: hasUndefinedRemoteKibanaUrl ? NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL : '',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.slo.sloDetails.headerControl.manageRules', {
      defaultMessage: 'Manage burn rate {count, plural, one {rule} other {rules}}',
      values: {
        count: rules.length
      }
    }), showRemoteLinkIcon)].concat(!!slo && (0, _indicator.isApmIndicatorType)(slo.indicator) ? /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "exploreInApm",
      icon: "bullseye",
      disabled: !hasApmReadCapabilities || isRemote,
      onClick: handleNavigateToApm,
      "data-test-subj": "sloDetailsHeaderControlPopoverExploreInApm",
      toolTipContent: isRemote ? NOT_AVAILABLE_FOR_REMOTE : '',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 281,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.slo.sloDetails.headerControl.exploreInApm', {
      defaultMessage: 'Service details'
    })) : []).concat(slo.enabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "disable",
      icon: "stop",
      disabled: !(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested) || hasUndefinedRemoteKibanaUrl,
      onClick: handleDisable,
      toolTipContent: hasUndefinedRemoteKibanaUrl ? NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL : '',
      "data-test-subj": "sloActionsDisable",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 299,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.slo.item.actions.disable', {
      defaultMessage: 'Disable'
    }), showRemoteLinkIcon) : /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "enable",
      icon: "play",
      disabled: !(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested) || hasUndefinedRemoteKibanaUrl,
      onClick: handleEnable,
      toolTipContent: hasUndefinedRemoteKibanaUrl ? NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL : '',
      "data-test-subj": "sloActionsEnable",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 313,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.slo.item.actions.enable', {
      defaultMessage: 'Enable'
    }), showRemoteLinkIcon), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "clone",
      disabled: !(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested) || hasUndefinedRemoteKibanaUrl,
      icon: "copy",
      onClick: handleClone,
      "data-test-subj": "sloDetailsHeaderControlPopoverClone",
      toolTipContent: hasUndefinedRemoteKibanaUrl ? NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL : '',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 327,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.slo.slo.item.actions.clone', {
      defaultMessage: 'Clone'
    }), showRemoteLinkIcon), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "delete",
      icon: "trash",
      disabled: !(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested) || hasUndefinedRemoteKibanaUrl,
      onClick: handleDelete,
      "data-test-subj": "sloDetailsHeaderControlPopoverDelete",
      toolTipContent: hasUndefinedRemoteKibanaUrl ? NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL : '',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 342,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.slo.slo.item.actions.delete', {
      defaultMessage: 'Delete'
    }), showRemoteLinkIcon), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "reset",
      icon: "refresh",
      disabled: !(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested) || hasUndefinedRemoteKibanaUrl,
      onClick: handleReset,
      "data-test-subj": "sloDetailsHeaderControlPopoverReset",
      toolTipContent: hasUndefinedRemoteKibanaUrl ? NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL : '',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 357,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.slo.slo.item.actions.reset', {
      defaultMessage: 'Reset'
    }), showRemoteLinkIcon)),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_edit_burn_rate_rule_flyout.EditBurnRateRuleFlyout, {
    rule: rules === null || rules === void 0 ? void 0 : rules[0],
    isEditRuleFlyoutOpen: isEditRuleFlyoutOpen,
    setIsEditRuleFlyoutOpen: setIsEditRuleFlyoutOpen,
    refetchRules: refetchRules,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 375,
      columnNumber: 7
    }
  }), isRuleFlyoutVisible ? /*#__PURE__*/_react.default.createElement(_flyout.RuleFormFlyout, {
    plugins: {
      ...services,
      actionTypeRegistry,
      ruleTypeRegistry
    },
    consumer: _common.sloFeatureId,
    ruleTypeId: _ruleDataUtils.SLO_BURN_RATE_RULE_TYPE_ID,
    onCancel: onCloseRuleFlyout,
    onSubmit: onCloseRuleFlyout,
    initialValues: {
      name: `${slo.name} burn rate`,
      params: {
        sloId: slo.id
      }
    },
    shouldUseRuleProducer: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 383,
      columnNumber: 9
    }
  }) : null);
}
const NOT_AVAILABLE_FOR_REMOTE = _i18n.i18n.translate('xpack.slo.item.actions.notAvailable', {
  defaultMessage: 'This action is not available for remote SLOs'
});
const NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL = _i18n.i18n.translate('xpack.slo.item.actions.remoteKibanaUrlUndefined', {
  defaultMessage: 'This action is not available for remote SLOs with undefined kibanaUrl'
});