"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloCardChartList = SloCardChartList;
var _react = _interopRequireDefault(require("react"));
var _sloSchema = require("@kbn/slo-schema");
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_kibana = require("../../../hooks/use_kibana");
var _slo_overview_details = require("../common/slo_overview_details");
var _use_fetch_slo_list = require("../../../hooks/use_fetch_slo_list");
var _chart_data_formatter = require("../../../utils/slo/chart_data_formatter");
var _use_fetch_rules_for_slo = require("../../../hooks/use_fetch_rules_for_slo");
var _use_fetch_active_alerts = require("../../../hooks/use_fetch_active_alerts");
var _slo_card_item_badges = require("../../../pages/slos/components/card_view/slo_card_item_badges");
var _use_slo_summary = require("../../../pages/slos/hooks/use_slo_summary");
var _slo_card_item = require("../../../pages/slos/components/card_view/slo_card_item");
var _use_fetch_historical_summary = require("../../../hooks/use_fetch_historical_summary");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/embeddable/slo/overview/slo_overview_grid.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getSloChartData = ({
  slo,
  historicalSummary,
  subTitle,
  cardColor,
  sliValue,
  sloTarget
}) => {
  const historicalSliData = (0, _chart_data_formatter.formatHistoricalData)(historicalSummary, 'sli_value');
  return {
    title: slo.name,
    subtitle: subTitle,
    value: sliValue,
    trendShape: _charts.MetricTrendShape.Area,
    trend: historicalSliData === null || historicalSliData === void 0 ? void 0 : historicalSliData.map(d => ({
      x: d.key,
      y: d.value
    })),
    extra: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.slo.sloGridItem.targetFlexItemLabel",
      defaultMessage: "Target {target}",
      values: {
        target: sloTarget
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 7
      }
    }),
    icon: () => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "visGauge",
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 17
      }
    }),
    color: cardColor
  };
};
const ROW_HEIGHT = 220;
const ITEMS_PER_ROW = 4;
function SloCardChartList({
  sloId
}) {
  var _sloList$results;
  const {
    http: {
      basePath
    },
    uiSettings,
    charts
  } = (0, _use_kibana.useKibana)().services;
  const baseTheme = charts.theme.useChartsBaseTheme();
  const [selectedSlo, setSelectedSlo] = _react.default.useState(null);
  const kqlQuery = `slo.id:"${sloId}"`;
  const {
    data: sloList,
    isLoading
  } = (0, _use_fetch_slo_list.useFetchSloList)({
    kqlQuery
  });
  const {
    data: activeAlertsBySlo
  } = (0, _use_fetch_active_alerts.useFetchActiveAlerts)({
    sloIdsAndInstanceIds: [[sloId, _sloSchema.ALL_VALUE]],
    rangeFrom: 'now-24h'
  });
  const {
    data: rulesBySlo
  } = (0, _use_fetch_rules_for_slo.useFetchRulesForSlo)({
    sloIds: [sloId]
  });
  const {
    data: historicalSummaries = []
  } = (0, _use_fetch_historical_summary.useFetchHistoricalSummary)({
    sloList: (_sloList$results = sloList === null || sloList === void 0 ? void 0 : sloList.results) !== null && _sloList$results !== void 0 ? _sloList$results : []
  });
  const {
    colors
  } = (0, _slo_card_item.useSloCardColor)();
  const chartsData = [[]];
  sloList === null || sloList === void 0 ? void 0 : sloList.results.forEach(slo => {
    var _slo$summary$status, _historicalSummaries$, _historicalSummaries$2;
    const subTitle = (0, _slo_card_item.getSubTitle)(slo);
    const cardColor = colors[(_slo$summary$status = slo.summary.status) !== null && _slo$summary$status !== void 0 ? _slo$summary$status : 'NO_DATA'];
    const {
      sliValue,
      sloTarget
    } = (0, _use_slo_summary.getSloFormattedSummary)(slo, uiSettings, basePath);
    const historicalSummary = (_historicalSummaries$ = (_historicalSummaries$2 = historicalSummaries.find(hist => hist.sloId === slo.id && hist.instanceId === slo.instanceId)) === null || _historicalSummaries$2 === void 0 ? void 0 : _historicalSummaries$2.data) !== null && _historicalSummaries$ !== void 0 ? _historicalSummaries$ : [];
    const lastArray = chartsData[chartsData.length - 1];
    if (lastArray.length >= 4) {
      // If the last array has reached its maximum length, create a new array
      chartsData.push([]);
    }
    const rules = rulesBySlo === null || rulesBySlo === void 0 ? void 0 : rulesBySlo[slo === null || slo === void 0 ? void 0 : slo.id];
    const activeAlerts = activeAlertsBySlo.get(slo);
    const data = getSloChartData({
      slo,
      subTitle,
      cardColor,
      sliValue,
      sloTarget,
      historicalSummary
    });
    data.body = /*#__PURE__*/_react.default.createElement(_slo_card_item_badges.SloCardItemBadges, {
      slo: slo,
      rules: rules,
      activeAlerts: activeAlerts,
      handleCreateRule: () => {},
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 7
      }
    });
    chartsData[chartsData.length - 1].push(data);
  });
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "center",
      style: {
        height: '100%'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 11
      }
    })));
  }
  const height = sloList !== null && sloList !== void 0 && sloList.results ? ROW_HEIGHT * Math.ceil(sloList.results.length / ITEMS_PER_ROW) : ROW_HEIGHT;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    "data-shared-item": "",
    style: {
      width: '100%',
      overflow: 'auto'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: baseTheme,
    onElementClick: ([d]) => {
      if ((0, _charts.isMetricElementEvent)(d)) {
        const {
          columnIndex,
          rowIndex
        } = d;
        const slo = sloList === null || sloList === void 0 ? void 0 : sloList.results[rowIndex * ITEMS_PER_ROW + columnIndex];
        setSelectedSlo(slo !== null && slo !== void 0 ? slo : null);
      }
    },
    locale: _i18n.i18n.getLocale(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Metric, {
    id: `slo-id-instances`,
    data: chartsData,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_slo_overview_details.SloOverviewDetails, {
    slo: selectedSlo,
    setSelectedSlo: setSelectedSlo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 7
    }
  }));
}