"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloConfiguration = SloConfiguration;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _sloSchema = require("@kbn/slo-schema");
var _i18n = require("@kbn/i18n");
var _slo_selector = require("../alerts/slo_selector");
var _slo_group_filters = require("./group_view/slo_group_filters");
var _overview_mode_selector = require("./overview_mode_selector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/embeddable/slo/overview/slo_configuration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SingleSloConfiguration({
  overviewMode,
  onCreate,
  onCancel
}) {
  const [selectedSlo, setSelectedSlo] = (0, _react.useState)();
  const [showAllGroupByInstances, setShowAllGroupByInstances] = (0, _react.useState)(false);
  const [hasError, setHasError] = (0, _react.useState)(false);
  const hasGroupBy = selectedSlo && selectedSlo.sloInstanceId !== _sloSchema.ALL_VALUE;
  const onConfirmClick = () => onCreate({
    showAllGroupByInstances,
    sloId: selectedSlo === null || selectedSlo === void 0 ? void 0 : selectedSlo.sloId,
    sloInstanceId: selectedSlo === null || selectedSlo === void 0 ? void 0 : selectedSlo.sloInstanceId,
    remoteName: selectedSlo === null || selectedSlo === void 0 ? void 0 : selectedSlo.remoteName,
    overviewMode
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "singleSloSelector",
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_slo_selector.SloSelector, {
    singleSelection: true,
    hasError: hasError,
    onSelected: slo => {
      setHasError(slo === undefined);
      if (slo && 'id' in slo) {
        var _slo$remote;
        setSelectedSlo({
          sloId: slo.id,
          sloInstanceId: slo.instanceId,
          remoteName: (_slo$remote = slo.remote) === null || _slo$remote === void 0 ? void 0 : _slo$remote.remoteName
        });
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 17
    }
  }))), hasGroupBy && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.slo.sloConfiguration.euiSwitch.showAllGroupByLabel', {
      defaultMessage: 'Show all related group-by instances'
    }),
    checked: showAllGroupByInstances,
    onChange: e => {
      setShowAllGroupByInstances(e.target.checked);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    "data-test-subj": "sloCancelButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloEmbeddable.config.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "sloConfirmButton",
    isDisabled: !selectedSlo || hasError,
    onClick: onConfirmClick,
    fill: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.overviewEmbeddableSlo.config.confirmButtonLabel",
    defaultMessage: "Save",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 13
    }
  })))));
}
function GroupSloConfiguration({
  overviewMode,
  onCreate,
  onCancel,
  initialInput
}) {
  var _initialInput$groupFi, _initialInput$groupFi2, _initialInput$groupFi3, _initialInput$groupFi4, _initialInput$groupFi5, _initialInput$groupFi6, _initialInput$groupFi7, _initialInput$groupFi8;
  const [selectedGroupFilters, setSelectedGroupFilters] = (0, _react.useState)({
    groupBy: (_initialInput$groupFi = initialInput === null || initialInput === void 0 ? void 0 : (_initialInput$groupFi2 = initialInput.groupFilters) === null || _initialInput$groupFi2 === void 0 ? void 0 : _initialInput$groupFi2.groupBy) !== null && _initialInput$groupFi !== void 0 ? _initialInput$groupFi : 'status',
    filters: (_initialInput$groupFi3 = initialInput === null || initialInput === void 0 ? void 0 : (_initialInput$groupFi4 = initialInput.groupFilters) === null || _initialInput$groupFi4 === void 0 ? void 0 : _initialInput$groupFi4.filters) !== null && _initialInput$groupFi3 !== void 0 ? _initialInput$groupFi3 : [],
    kqlQuery: (_initialInput$groupFi5 = initialInput === null || initialInput === void 0 ? void 0 : (_initialInput$groupFi6 = initialInput.groupFilters) === null || _initialInput$groupFi6 === void 0 ? void 0 : _initialInput$groupFi6.kqlQuery) !== null && _initialInput$groupFi5 !== void 0 ? _initialInput$groupFi5 : '',
    groups: (_initialInput$groupFi7 = initialInput === null || initialInput === void 0 ? void 0 : (_initialInput$groupFi8 = initialInput.groupFilters) === null || _initialInput$groupFi8 === void 0 ? void 0 : _initialInput$groupFi8.groups) !== null && _initialInput$groupFi7 !== void 0 ? _initialInput$groupFi7 : []
  });
  const onConfirmClick = () => onCreate({
    groupFilters: selectedGroupFilters,
    overviewMode
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "sloGroupOverviewConfiguration",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_slo_group_filters.SloGroupFilters, {
    selectedFilters: selectedGroupFilters,
    onSelected: (prop, value) => {
      setSelectedGroupFilters(prevState => ({
        ...prevState,
        [prop]: value
      }));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 17
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    "data-test-subj": "sloCancelButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloEmbeddable.config.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "sloConfirmButton",
    onClick: onConfirmClick,
    fill: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.overviewEmbeddableSlo.config.confirmButtonLabel",
    defaultMessage: "Save",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 13
    }
  })))));
}
function SloConfiguration({
  initialInput,
  onCreate,
  onCancel
}) {
  var _initialInput$overvie;
  const [overviewMode, setOverviewMode] = (0, _react.useState)((_initialInput$overvie = initialInput === null || initialInput === void 0 ? void 0 : initialInput.overviewMode) !== null && _initialInput$overvie !== void 0 ? _initialInput$overvie : 'single');
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'overviewConfigurationFlyout'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "data-test-subj": "sloSingleOverviewConfiguration",
    onClose: onCancel,
    "aria-labelledby": flyoutTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.slo.overviewEmbeddable.config.sloSelector.headerTitle', {
    defaultMessage: 'Overview configuration'
  })))), (initialInput === null || initialInput === void 0 ? void 0 : initialInput.overviewMode) === undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_mode_selector.OverviewModeSelector, {
    value: overviewMode,
    onChange: mode => setOverviewMode(mode),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 15
    }
  })))), overviewMode === 'groups' ? /*#__PURE__*/_react.default.createElement(GroupSloConfiguration, {
    initialInput: initialInput,
    overviewMode: overviewMode,
    onCreate: onCreate,
    onCancel: onCancel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(SingleSloConfiguration, {
    overviewMode: overviewMode,
    onCreate: onCreate,
    onCancel: onCancel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 9
    }
  }));
}