"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LongWindowDuration = LongWindowDuration;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/components/burn_rate_rule_editor/long_window_duration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function LongWindowDuration({
  initialDuration,
  onChange,
  errors
}) {
  var _initialDuration$valu;
  const [durationValue, setDurationValue] = (0, _react.useState)((_initialDuration$valu = initialDuration === null || initialDuration === void 0 ? void 0 : initialDuration.value) !== null && _initialDuration$valu !== void 0 ? _initialDuration$valu : 1);
  const hasError = errors !== undefined && errors.length > 0;
  const onDurationValueChange = e => {
    const value = Number(e.target.value);
    setDurationValue(value);
    onChange({
      value,
      unit: 'h'
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: getRowLabel(),
    fullWidth: true,
    isInvalid: hasError,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    isInvalid: hasError,
    min: 1,
    max: 72,
    step: 1,
    value: String(durationValue),
    onChange: onDurationValueChange,
    "aria-label": _i18n.i18n.translate('xpack.slo.rules.longWindow.valueLabel', {
      defaultMessage: 'Long lookback period in hours'
    }),
    "data-test-subj": "durationValueInput",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }));
}
const getRowLabel = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.slo.rules.longWindow.rowLabel', {
  defaultMessage: 'Long lookback (hours)'
}), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  position: "top",
  content: _i18n.i18n.translate('xpack.slo.rules.longWindowDuration.tooltip', {
    defaultMessage: 'Long lookback period over which the burn rate is computed.'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 53,
    columnNumber: 5
  }
}));