"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SharePlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _configSchema = require("@kbn/config-schema");
var _register_delete_unused_urls_route = require("./unused_urls_task/register_delete_unused_urls_route");
var _unused_urls_task = require("./unused_urls_task");
var _constants = require("../common/constants");
var _url_service = require("../common/url_service");
var _url_service2 = require("./url_service");
var _legacy_short_url_locator = require("../common/url_service/locators/legacy_short_url_locator");
var _short_url_redirect_locator = require("../common/url_service/locators/short_url_redirect_locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @public */

/** @public */

class SharePlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "url", void 0);
    (0, _defineProperty2.default)(this, "version", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    this.initializerContext = initializerContext;
    this.version = initializerContext.env.packageInfo.version;
    this.logger = initializerContext.logger.get();
    this.config = initializerContext.config.get();
  }
  setup(core, {
    taskManager
  }) {
    this.url = new _url_service.UrlService({
      baseUrl: core.http.basePath.publicBaseUrl || core.http.basePath.serverBasePath,
      version: this.initializerContext.env.packageInfo.version,
      navigate: async () => {
        throw new Error('Locator .navigate() is not supported on the server.');
      },
      getUrl: async () => {
        throw new Error('Locator .getUrl() currently is not supported on the server.');
      },
      shortUrls: ({
        locators
      }) => new _url_service2.ServerShortUrlClientFactory({
        currentVersion: this.version,
        locators
      })
    });
    this.url.locators.create(new _legacy_short_url_locator.LegacyShortUrlLocatorDefinition());
    this.url.locators.create(new _short_url_redirect_locator.ShortUrlRedirectLocatorDefinition());
    (0, _url_service2.registerUrlServiceSavedObjectType)(core.savedObjects, this.url);
    (0, _url_service2.registerUrlServiceRoutes)(core, core.http.createRouter(), this.url);
    (0, _register_delete_unused_urls_route.registerDeleteUnusedUrlsRoute)({
      router: core.http.createRouter(),
      core,
      urlExpirationDuration: this.config.url_expiration.duration,
      urlLimit: this.config.url_expiration.url_limit,
      logger: this.logger,
      isEnabled: this.config.url_expiration.enabled && Boolean(taskManager)
    });
    core.uiSettings.register({
      [_constants.CSV_SEPARATOR_SETTING]: {
        name: _i18n.i18n.translate('share.advancedSettings.csv.separatorTitle', {
          defaultMessage: 'CSV separator'
        }),
        value: ',',
        description: _i18n.i18n.translate('share.advancedSettings.csv.separatorText', {
          defaultMessage: 'Separate exported values with this string'
        }),
        schema: _configSchema.schema.string()
      },
      [_constants.CSV_QUOTE_VALUES_SETTING]: {
        name: _i18n.i18n.translate('share.advancedSettings.csv.quoteValuesTitle', {
          defaultMessage: 'Quote CSV values'
        }),
        value: true,
        description: _i18n.i18n.translate('share.advancedSettings.csv.quoteValuesText', {
          defaultMessage: 'Should values be quoted in csv exports?'
        }),
        schema: _configSchema.schema.boolean()
      }
    });
    if (taskManager) {
      taskManager.registerTaskDefinitions({
        [_unused_urls_task.TASK_ID]: {
          title: 'Unused URLs Cleanup',
          description: "Deletes unused saved objects of type 'url'",
          maxAttempts: 5,
          createTaskRunner: () => ({
            run: async () => {
              await (0, _unused_urls_task.runDeleteUnusedUrlsTask)({
                core,
                urlExpirationDuration: this.config.url_expiration.duration,
                logger: this.logger,
                urlLimit: this.config.url_expiration.url_limit,
                isEnabled: this.config.url_expiration.enabled
              });
            }
          })
        }
      });
    }
    return {
      url: this.url
    };
  }
  start(_core, {
    taskManager
  }) {
    this.logger.debug('Starting plugin');
    if (taskManager) {
      void (0, _unused_urls_task.scheduleUnusedUrlsCleanupTask)({
        taskManager,
        checkInterval: this.config.url_expiration.check_interval,
        isEnabled: this.config.url_expiration.enabled
      });
    }
    return {
      url: this.url
    };
  }
  stop() {
    this.logger.debug('Stopping plugin');
  }
}
exports.SharePlugin = SharePlugin;