"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlPanelContent = exports.ExportUrlAsType = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _url = require("url");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/share/public/components/url_panel_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let ExportUrlAsType = exports.ExportUrlAsType = /*#__PURE__*/function (ExportUrlAsType) {
  ExportUrlAsType["EXPORT_URL_AS_SAVED_OBJECT"] = "savedObject";
  ExportUrlAsType["EXPORT_URL_AS_SNAPSHOT"] = "snapshot";
  return ExportUrlAsType;
}({});
class UrlPanelContentComponent extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "mounted", void 0);
    (0, _defineProperty2.default)(this, "shortUrlCache", void 0);
    (0, _defineProperty2.default)(this, "isNotSaved", () => {
      return this.props.objectId === undefined || this.props.objectId === '';
    });
    (0, _defineProperty2.default)(this, "resetUrl", () => {
      if (this.mounted) {
        this.shortUrlCache = undefined;
        this.setState({
          useShortUrl: false
        }, this.setUrl);
      }
    });
    (0, _defineProperty2.default)(this, "updateUrlParams", url => {
      url = this.props.isEmbedded ? this.makeUrlEmbeddable(url) : url;
      url = this.state.urlParams ? this.getUrlParamExtensions(url) : url;
      return url;
    });
    (0, _defineProperty2.default)(this, "getSavedObjectUrl", () => {
      if (this.isNotSaved()) {
        return;
      }
      const url = this.getSnapshotUrl(true);
      const parsedUrl = (0, _url.parse)(url);
      if (!parsedUrl || !parsedUrl.hash) {
        return;
      }

      // Get the application route, after the hash, and remove the #.
      const parsedAppUrl = (0, _url.parse)(parsedUrl.hash.slice(1), true);
      const formattedUrl = (0, _url.format)({
        protocol: parsedUrl.protocol,
        auth: parsedUrl.auth,
        host: parsedUrl.host,
        pathname: parsedUrl.pathname,
        hash: (0, _url.format)({
          pathname: parsedAppUrl.pathname,
          query: {
            // Add global state to the URL so that the iframe doesn't just show the time range
            // default.
            _g: parsedAppUrl.query._g
          }
        })
      });
      return this.updateUrlParams(formattedUrl);
    });
    (0, _defineProperty2.default)(this, "getSnapshotUrl", forSavedObject => {
      let url = '';
      if (forSavedObject && this.props.shareableUrlForSavedObject) {
        url = this.props.shareableUrlForSavedObject;
      }
      if (!url) {
        url = this.props.shareableUrl || window.location.href;
      }
      return this.updateUrlParams(url);
    });
    (0, _defineProperty2.default)(this, "makeUrlEmbeddable", url => {
      const embedParam = '?embed=true';
      const urlHasQueryString = url.indexOf('?') !== -1;
      if (urlHasQueryString) {
        return url.replace('?', `${embedParam}&`);
      }
      return `${url}${embedParam}`;
    });
    (0, _defineProperty2.default)(this, "addUrlAnonymousAccessParameters", url => {
      if (!this.state.anonymousAccessParameters || !this.state.usePublicUrl) {
        return url;
      }
      const parsedUrl = new URL(url);
      for (const [name, value] of Object.entries(this.state.anonymousAccessParameters)) {
        parsedUrl.searchParams.set(name, value);
      }
      return parsedUrl.toString();
    });
    (0, _defineProperty2.default)(this, "getUrlParamExtensions", url => {
      const {
        urlParams
      } = this.state;
      return urlParams ? Object.keys(urlParams).reduce((urlAccumulator, key) => {
        const urlParam = urlParams[key];
        return urlParam ? Object.keys(urlParam).reduce((queryAccumulator, queryParam) => {
          const isQueryParamEnabled = urlParam[queryParam];
          return isQueryParamEnabled ? queryAccumulator + `&${queryParam}=true` : queryAccumulator;
        }, urlAccumulator) : urlAccumulator;
      }, url) : url;
    });
    (0, _defineProperty2.default)(this, "makeIframeTag", url => {
      if (!url) {
        return;
      }
      return `<iframe src="${url}" height="600" width="800"></iframe>`;
    });
    (0, _defineProperty2.default)(this, "setUrl", () => {
      let url;
      if (this.state.exportUrlAs === ExportUrlAsType.EXPORT_URL_AS_SAVED_OBJECT) {
        url = this.getSavedObjectUrl();
      } else if (this.state.useShortUrl) {
        url = this.shortUrlCache;
      } else {
        url = this.getSnapshotUrl();
      }
      if (url) {
        url = this.addUrlAnonymousAccessParameters(url);
      }
      if (this.props.isEmbedded) {
        url = this.makeIframeTag(url);
      }
      this.setState({
        url
      });
    });
    (0, _defineProperty2.default)(this, "handleExportUrlAs", optionId => {
      this.setState({
        showWarningButton: Boolean(this.props.snapshotShareWarning) && optionId === ExportUrlAsType.EXPORT_URL_AS_SNAPSHOT,
        exportUrlAs: optionId
      }, this.setUrl);
    });
    (0, _defineProperty2.default)(this, "handleShortUrlChange", async evt => {
      const isChecked = evt.target.checked;
      if (!isChecked || this.shortUrlCache !== undefined) {
        this.setState({
          useShortUrl: isChecked
        }, this.setUrl);
        return;
      }

      // "Use short URL" is checked but shortUrl has not been generated yet so one needs to be created.
      this.createShortUrl();
    });
    (0, _defineProperty2.default)(this, "handlePublicUrlChange", () => {
      this.setState(({
        usePublicUrl
      }) => {
        return {
          usePublicUrl: !usePublicUrl
        };
      }, this.setUrl);
    });
    (0, _defineProperty2.default)(this, "createShortUrl", async () => {
      this.setState({
        isCreatingShortUrl: true,
        shortUrlErrorMsg: undefined
      });
      try {
        const {
          shareableUrlLocatorParams
        } = this.props;
        if (shareableUrlLocatorParams) {
          const shortUrls = this.props.urlService.shortUrls.get(null);
          const shortUrl = await shortUrls.createWithLocator(shareableUrlLocatorParams);
          this.shortUrlCache = await shortUrl.locator.getUrl(shortUrl.params, {
            absolute: true
          });
        } else {
          const snapshotUrl = this.getSnapshotUrl();
          const shortUrl = await this.props.urlService.shortUrls.get(null).createFromLongUrl(snapshotUrl);
          this.shortUrlCache = shortUrl.url;
        }
        if (!this.mounted) {
          return;
        }
        this.setState({
          isCreatingShortUrl: false,
          useShortUrl: true
        }, this.setUrl);
      } catch (fetchError) {
        if (!this.mounted) {
          return;
        }
        this.shortUrlCache = undefined;
        this.setState({
          useShortUrl: false,
          isCreatingShortUrl: false,
          shortUrlErrorMsg: _i18n.i18n.translate('share.urlPanel.unableCreateShortUrlErrorMessage', {
            defaultMessage: 'Unable to create short URL. Error: {errorMessage}',
            values: {
              errorMessage: fetchError.message
            }
          })
        }, this.setUrl);
      }
    });
    (0, _defineProperty2.default)(this, "renderCopyButton", () => /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      beforeMessage: this.state.showWarningButton ? this.props.snapshotShareWarning : undefined,
      textToCopy: this.state.url || '',
      tooltipProps: {
        anchorClassName: 'eui-displayBlock'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 410,
        columnNumber: 5
      }
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      fullWidth: true,
      onClick: copy,
      disabled: this.state.isCreatingShortUrl || this.state.url === '',
      "data-share-url": this.state.url,
      "data-test-subj": "copyShareUrlButton",
      size: "s",
      iconType: this.state.showWarningButton ? 'warning' : undefined,
      color: this.state.showWarningButton ? 'warning' : 'primary',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 416,
        columnNumber: 9
      }
    }, this.props.isEmbedded ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "share.urlPanel.copyIframeCodeButtonLabel",
      defaultMessage: "Copy iFrame code",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 428,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "share.urlPanel.copyLinkButtonLabel",
      defaultMessage: "Copy link",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 433,
        columnNumber: 13
      }
    }))));
    (0, _defineProperty2.default)(this, "renderExportUrlAsOptions", () => {
      const snapshotLabel = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "share.urlPanel.snapshotLabel",
        defaultMessage: "Snapshot",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 442,
          columnNumber: 7
        }
      });
      return [{
        id: ExportUrlAsType.EXPORT_URL_AS_SNAPSHOT,
        label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.renderWithIconTip(snapshotLabel, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "share.urlPanel.snapshotDescription",
          defaultMessage: "Snapshot URLs encode the current state of the {objectType} in the URL itself. Edits to the saved {objectType} won't be visible via this URL.",
          values: {
            objectType: this.props.objectType
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 451,
            columnNumber: 15
          }
        }))),
        ['data-test-subj']: 'exportAsSnapshot'
      }, {
        id: ExportUrlAsType.EXPORT_URL_AS_SAVED_OBJECT,
        disabled: this.isNotSaved(),
        label: this.renderWithIconTip(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "share.urlPanel.savedObjectLabel",
          defaultMessage: "Saved object",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 466,
            columnNumber: 11
          }
        }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "share.urlPanel.savedObjectDescription",
          defaultMessage: "You can share this URL with people to let them load the most recent saved version of this {objectType}.",
          values: {
            objectType: this.props.objectType
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 467,
            columnNumber: 11
          }
        })),
        ['data-test-subj']: 'exportAsSavedObject'
      }];
    });
    (0, _defineProperty2.default)(this, "renderWithIconTip", (child, tipContent) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "none",
        responsive: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 480,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 481,
          columnNumber: 9
        }
      }, child), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 482,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: tipContent,
        position: "bottom",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 483,
          columnNumber: 11
        }
      })));
    });
    (0, _defineProperty2.default)(this, "renderExportAsRadioGroup", () => {
      const generateLinkAsHelp = this.isNotSaved() ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "share.urlPanel.canNotShareAsSavedObjectHelpText",
        defaultMessage: "To share as a saved object, save the {objectType}.",
        values: {
          objectType: this.props.objectType
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 491,
          columnNumber: 7
        }
      }) : undefined;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        helpText: generateLinkAsHelp,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 498,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
        name: "exportUrlAs",
        options: this.renderExportUrlAsOptions(),
        idSelected: this.state.exportUrlAs,
        onChange: this.handleExportUrlAs,
        legend: {
          children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "share.urlPanel.generateLinkAsLabel",
            defaultMessage: "Generate the link as",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 506,
              columnNumber: 15
            }
          })
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 499,
          columnNumber: 9
        }
      }));
    });
    (0, _defineProperty2.default)(this, "renderShortUrlSwitch", () => {
      if (this.state.exportUrlAs === ExportUrlAsType.EXPORT_URL_AS_SAVED_OBJECT || !this.props.allowShortUrl) {
        return null;
      }
      const shortUrlLabel = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "share.urlPanel.shortUrlLabel",
        defaultMessage: "Short URL",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 525,
          columnNumber: 7
        }
      });
      const switchLabel = this.state.isCreatingShortUrl ? /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 528,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 529,
          columnNumber: 9
        }
      }), " ", shortUrlLabel) : shortUrlLabel;
      const switchComponent = /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        label: switchLabel,
        checked: this.state.useShortUrl,
        onChange: this.handleShortUrlChange,
        "data-test-subj": "useShortUrl",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 535,
          columnNumber: 7
        }
      });
      const tipContent = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "share.urlPanel.shortUrlHelpText",
        defaultMessage: "We recommend sharing shortened snapshot URLs for maximum compatibility. Internet Explorer has URL length restrictions, and some wiki and markup parsers don't do well with the full-length version of the snapshot URL, but the short URL should work great.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 543,
          columnNumber: 7
        }
      });
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        helpText: this.state.shortUrlErrorMsg,
        "data-test-subj": "createShortUrl",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 553,
          columnNumber: 7
        }
      }, this.renderWithIconTip(switchComponent, tipContent));
    });
    (0, _defineProperty2.default)(this, "renderPublicUrlSwitch", () => {
      if (!this.state.anonymousAccessParameters || !this.state.showPublicUrlSwitch) {
        return null;
      }
      const switchLabel = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "share.urlPanel.publicUrlLabel",
        defaultMessage: "Public URL",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 565,
          columnNumber: 7
        }
      });
      const switchComponent = /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        label: switchLabel,
        checked: this.state.usePublicUrl,
        onChange: this.handlePublicUrlChange,
        "data-test-subj": "usePublicUrl",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 568,
          columnNumber: 7
        }
      });
      const tipContent = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "share.urlPanel.publicUrlHelpText",
        defaultMessage: "Use public URL to share with anyone. It enables one-step anonymous access by removing the login prompt.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 576,
          columnNumber: 7
        }
      });
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        "data-test-subj": "createPublicUrl",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 583,
          columnNumber: 7
        }
      }, this.renderWithIconTip(switchComponent, tipContent));
    });
    (0, _defineProperty2.default)(this, "renderUrlParamExtensions", () => {
      if (!this.props.urlParamExtensions) {
        return;
      }
      const setParamValue = paramName => (values = {}) => {
        const stateUpdate = {
          urlParams: {
            ...this.state.urlParams,
            [paramName]: {
              ...values
            }
          }
        };
        this.setState(stateUpdate, this.state.useShortUrl ? this.createShortUrl : this.setUrl);
      };
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 609,
          columnNumber: 7
        }
      }, this.props.urlParamExtensions.map(({
        paramName,
        component: UrlParamComponent
      }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        key: paramName,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 611,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(UrlParamComponent, {
        setParamValue: setParamValue(paramName),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 612,
          columnNumber: 13
        }
      }))));
    });
    this.shortUrlCache = undefined;
    this.state = {
      exportUrlAs: ExportUrlAsType.EXPORT_URL_AS_SNAPSHOT,
      useShortUrl: false,
      usePublicUrl: false,
      isCreatingShortUrl: false,
      url: '',
      anonymousAccessParameters: null,
      showPublicUrlSwitch: false,
      showWarningButton: Boolean(this.props.snapshotShareWarning)
    };
  }
  componentWillUnmount() {
    window.removeEventListener('hashchange', this.resetUrl);
    this.mounted = false;
  }
  componentDidMount() {
    this.mounted = true;
    this.setUrl();
    window.addEventListener('hashchange', this.resetUrl, false);
    if (this.props.anonymousAccess) {
      (async () => {
        const {
          accessURLParameters: anonymousAccessParameters
        } = await this.props.anonymousAccess.getState();
        if (!this.mounted) {
          return;
        }
        if (!anonymousAccessParameters) {
          return;
        }
        let showPublicUrlSwitch = false;
        if (this.props.showPublicUrlSwitch) {
          const anonymousUserCapabilities = await this.props.anonymousAccess.getCapabilities();
          if (!this.mounted) {
            return;
          }
          try {
            showPublicUrlSwitch = this.props.showPublicUrlSwitch(anonymousUserCapabilities);
          } catch {
            showPublicUrlSwitch = false;
          }
        }
        this.setState({
          anonymousAccessParameters,
          showPublicUrlSwitch
        });
      })();
    }
  }
  render() {
    const {
      theme
    } = this.props;
    const shortUrlSwitch = this.renderShortUrlSwitch();
    const publicUrlSwitch = this.renderPublicUrlSwitch();
    const copyButton = this.renderCopyButton();
    const urlRow = (!!shortUrlSwitch || !!publicUrlSwitch) && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "share.urlPanel.urlGroupTitle",
        defaultMessage: "URL",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 161,
          columnNumber: 16
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: 's',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 11
      }
    }), shortUrlSwitch, publicUrlSwitch));
    return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      css: (0, _react2.css)({
        padding: theme.euiTheme.size.base
      }),
      "data-test-subj": "shareUrlForm",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 9
      }
    }, this.renderExportAsRadioGroup(), this.renderUrlParamExtensions(), urlRow, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 11
      }
    }), copyButton));
  }
}
const UrlPanelContent = exports.UrlPanelContent = (0, _eui.withEuiTheme)(UrlPanelContentComponent);
UrlPanelContent.displayName = 'UrlPanelContent';