"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkContent = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _time_type_section = require("./time_type_section");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/share/public/components/tabs/link/link_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LinkContent = ({
  isDirty,
  objectType,
  objectConfig = {},
  shareableUrl,
  shortUrlService,
  shareableUrlLocatorParams,
  allowShortUrl
}) => {
  var _shareableUrlLocatorP;
  const [snapshotUrl, setSnapshotUrl] = (0, _react.useState)('');
  const [isTextCopied, setTextCopied] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [isAbsoluteTime, setIsAbsoluteTime] = (0, _react.useState)(true);
  const urlParamsRef = (0, _react.useRef)(undefined);
  const urlToCopy = (0, _react.useRef)(undefined);
  const copiedTextToolTipCleanupIdRef = (0, _react.useRef)();
  const timeRange = shareableUrlLocatorParams === null || shareableUrlLocatorParams === void 0 ? void 0 : (_shareableUrlLocatorP = shareableUrlLocatorParams.params) === null || _shareableUrlLocatorP === void 0 ? void 0 : _shareableUrlLocatorP.timeRange;
  const {
    delegatedShareUrlHandler,
    draftModeCallOut: DraftModeCallout
  } = objectConfig;
  const getUrlWithUpdatedParams = (0, _react.useCallback)(tempUrl => {
    const urlWithUpdatedParams = urlParamsRef.current ? Object.keys(urlParamsRef.current).reduce((urlAccumulator, key) => {
      var _urlParamsRef$current;
      const urlParam = (_urlParamsRef$current = urlParamsRef.current) === null || _urlParamsRef$current === void 0 ? void 0 : _urlParamsRef$current[key];
      return urlParam ? Object.keys(urlParam).reduce((queryAccumulator, queryParam) => {
        const isQueryParamEnabled = urlParam[queryParam];
        return isQueryParamEnabled ? queryAccumulator + `&${queryParam}=true` : queryAccumulator;
      }, urlAccumulator) : urlAccumulator;
    }, tempUrl) : tempUrl;
    return urlWithUpdatedParams;
  }, []);
  (0, _react.useEffect)(() => {
    setSnapshotUrl(getUrlWithUpdatedParams(shareableUrl || window.location.href));
  }, [getUrlWithUpdatedParams, shareableUrl]);
  const createShortUrl = (0, _react.useCallback)(async () => {
    if (shareableUrlLocatorParams) {
      const shortUrl = await shortUrlService.createWithLocator(shareableUrlLocatorParams, isAbsoluteTime);
      return shortUrl.locator.getUrl(shortUrl.params, {
        absolute: true
      });
    } else {
      return (await shortUrlService.createFromLongUrl(snapshotUrl, isAbsoluteTime)).url;
    }
  }, [shareableUrlLocatorParams, shortUrlService, snapshotUrl, isAbsoluteTime]);
  const copyUrlHelper = (0, _react.useCallback)(async () => {
    setIsLoading(true);
    if (!urlToCopy.current) {
      urlToCopy.current = delegatedShareUrlHandler ? await delegatedShareUrlHandler() : allowShortUrl ? await createShortUrl() : snapshotUrl;
    }
    (0, _eui.copyToClipboard)(urlToCopy.current);
    setTextCopied(() => {
      if (copiedTextToolTipCleanupIdRef.current) {
        clearTimeout(copiedTextToolTipCleanupIdRef.current);
      }

      // set up timer to revert copied state to false after specified duration
      copiedTextToolTipCleanupIdRef.current = setTimeout(() => setTextCopied(false), 1000);

      // set copied state to true for now
      return true;
    });
    setIsLoading(false);
  }, [snapshotUrl, delegatedShareUrlHandler, allowShortUrl, createShortUrl]);
  const changeTimeType = e => {
    setIsAbsoluteTime(e.target.checked);
    if (urlToCopy !== null && urlToCopy !== void 0 && urlToCopy.current && e.target.checked !== isAbsoluteTime) {
      urlToCopy.current = undefined;
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_time_type_section.TimeTypeSection, {
    timeRange: timeRange,
    isAbsoluteTime: isAbsoluteTime,
    changeTimeType: changeTimeType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }), isDirty && DraftModeCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 13
    }
  }), DraftModeCallout), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isTextCopied ? _i18n.i18n.translate('share.link.copied', {
      defaultMessage: 'Link copied'
    }) : null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    "data-test-subj": "copyShareUrlButton",
    "data-share-url": urlToCopy.current,
    onBlur: () => objectType === 'lens' && isDirty ? null : setTextCopied(false),
    onClick: copyUrlHelper,
    color: objectType === 'lens' && isDirty ? 'warning' : 'primary',
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.link.copyLinkButton",
    defaultMessage: "Copy link",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 15
    }
  }))))));
};
exports.LinkContent = LinkContent;