"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessTreeAlertsFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../common/constants");
var _styles = require("./styles");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/session_view/public/components/process_tree_alerts_filter/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ProcessTreeAlertsFilter = ({
  totalAlertsCount,
  alertTypeCounts,
  filteredAlertsCount,
  onAlertEventCategorySelected
}) => {
  const {
    filterStatus,
    popover
  } = (0, _styles.useStyles)();
  const [selectedProcessEventAlertCategory, setSelectedProcessEventAlertCategory] = (0, _react.useState)('all');
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const onButtonClick = () => {
    setPopover(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopover(false);
  };
  const onSelectedProcessEventAlertCategory = (0, _react.useCallback)(event => {
    const [_, selectedAlertEvent] = event.target.textContent.split(' ');
    setSelectedProcessEventAlertCategory(selectedAlertEvent);
    onAlertEventCategorySelected(selectedAlertEvent);
    closePopover();
  }, [onAlertEventCategorySelected]);
  const doesMultipleAlertTypesExist = (0, _react.useMemo)(() => {
    // Check if alerts consist of at least two alert event types
    const multipleAlertTypeCount = alertTypeCounts.reduce((sumOfAlertTypes, {
      count
    }) => {
      if (count > 0) {
        return sumOfAlertTypes += 1;
      }
      return 0;
    }, 0);
    return multipleAlertTypeCount > 1;
  }, [alertTypeCounts]);
  const alertEventCategoryFilterMenuButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "sessionView:sessionViewAlertDetailsEmptyFilterButton",
    size: "s",
    iconType: "arrowDown",
    iconSide: "right",
    onClick: onButtonClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, _translations.SELECTED_PROCESS[selectedProcessEventAlertCategory]);
  const alertEventCategoryFilterMenuItems = (0, _react.useMemo)(() => {
    const getIconType = eventCategory => {
      return eventCategory === selectedProcessEventAlertCategory ? 'check' : 'empty';
    };
    const alertEventFilterMenuItems = alertTypeCounts.filter(({
      count
    }) => count > 0).map(({
      category: processEventAlertCategory
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": `sessionView:sessionViewAlertDetailsFilterItem-${processEventAlertCategory}`,
        key: processEventAlertCategory,
        icon: getIconType(processEventAlertCategory),
        onClick: onSelectedProcessEventAlertCategory,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 96,
          columnNumber: 11
        }
      }, _translations.FILTER_MENU_OPTIONS[processEventAlertCategory]);
    });
    return [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": `sessionView:sessionViewAlertDetailsFilterItem-default`,
      key: _constants.DEFAULT_ALERT_FILTER_VALUE,
      icon: getIconType(_constants.DEFAULT_ALERT_FILTER_VALUE),
      onClick: onSelectedProcessEventAlertCategory,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 7
      }
    }, _translations.FILTER_MENU_OPTIONS.all), ...alertEventFilterMenuItems];
  }, [selectedProcessEventAlertCategory, alertTypeCounts, onSelectedProcessEventAlertCategory]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "sessionView:sessionViewAlertDetailsFilter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)([filterStatus, {
      paddingLeft: '16px'
    }]),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "sessionView:sessionViewAlertDetailsFilterStatus",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  }, totalAlertsCount === filteredAlertsCount && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.sessionView.alertTotalCountStatusLabel",
    defaultMessage: "{count, plural, one {Showing <bold>#</bold> alert} other {Showing <bold>#</bold> alerts}}",
    values: {
      count: totalAlertsCount,
      bold: str => /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 34
        }
      }, str)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 15
    }
  }), totalAlertsCount !== filteredAlertsCount && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.sessionView.alertFilteredCountStatusLabel",
    defaultMessage: " Showing {count} alerts",
    values: {
      count: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 21
        }
      }, filteredAlertsCount, " of ", totalAlertsCount)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 15
    }
  }))), doesMultipleAlertTypesExist && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: popover,
    grow: false,
    "data-test-subj": "sessionView:sessionViewAlertDetailsFilterSelectorContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: alertEventCategoryFilterMenuButton,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    "data-test-subj": "sessionView:sessionViewAlertDetailsFilterSelectorContainerMenu",
    size: "s",
    className: 'filterMenu',
    items: alertEventCategoryFilterMenuItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 7
    }
  }));
};
exports.ProcessTreeAlertsFilter = ProcessTreeAlertsFilter;