"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessTreeAlerts = ProcessTreeAlerts;
var _react = _interopRequireWildcard(require("react"));
var _styles = require("./styles");
var _process_tree_alert = require("../process_tree_alert");
var _constants = require("../../../common/constants");
var _process_tree_alerts_filter = require("../process_tree_alerts_filter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/session_view/public/components/process_tree_alerts/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ProcessTreeAlerts({
  alerts,
  investigatedAlertId,
  isProcessSelected = false,
  alertTypeCounts,
  onAlertSelected,
  onShowAlertDetails
}) {
  const [selectedAlert, setSelectedAlert] = (0, _react.useState)(null);
  const [selectedProcessEventAlertCategory, setSelectedProcessEventAlertCategory] = (0, _react.useState)(_constants.DEFAULT_ALERT_FILTER_VALUE);
  const styles = (0, _styles.useStyles)();
  (0, _react.useEffect)(() => {
    const jumpToAlert = investigatedAlertId && alerts.find(alert => {
      var _alert$kibana, _alert$kibana$alert;
      return ((_alert$kibana = alert.kibana) === null || _alert$kibana === void 0 ? void 0 : (_alert$kibana$alert = _alert$kibana.alert) === null || _alert$kibana$alert === void 0 ? void 0 : _alert$kibana$alert.uuid) === investigatedAlertId;
    });
    if (jumpToAlert) {
      var _jumpToAlert$kibana;
      setSelectedAlert((_jumpToAlert$kibana = jumpToAlert.kibana) === null || _jumpToAlert$kibana === void 0 ? void 0 : _jumpToAlert$kibana.alert);
    }
  }, [investigatedAlertId, alerts]);
  const scrollerRef = (0, _react.useRef)(null);
  const selectAlert = (0, _react.useCallback)(alertUuid => {
    if (!(scrollerRef !== null && scrollerRef !== void 0 && scrollerRef.current)) {
      return;
    }
    const alertEl = scrollerRef.current.querySelector(`[data-id="${alertUuid}"]`);
    if (alertEl) {
      const cTop = scrollerRef.current.scrollTop;
      const cBottom = cTop + scrollerRef.current.clientHeight;
      const eTop = alertEl.offsetTop;
      const eBottom = eTop + alertEl.clientHeight;
      const isVisible = eTop >= cTop && eBottom <= cBottom;
      if (!isVisible) {
        alertEl.scrollIntoView({
          block: 'nearest'
        });
      }
    }
  }, []);
  const handleAlertClick = (0, _react.useCallback)(alert => {
    onAlertSelected(_constants.MOUSE_EVENT_PLACEHOLDER);
    setSelectedAlert(alert);
  }, [onAlertSelected]);
  const handleProcessEventAlertCategorySelected = (0, _react.useCallback)(eventCategory => {
    setSelectedProcessEventAlertCategory(eventCategory);
  }, []);
  const filteredProcessEventAlerts = (0, _react.useMemo)(() => {
    return alerts === null || alerts === void 0 ? void 0 : alerts.filter(processEventAlert => {
      var _processEventAlert$ev, _processEventAlert$ev2;
      const processEventAlertCategory = (_processEventAlert$ev = processEventAlert.event) === null || _processEventAlert$ev === void 0 ? void 0 : (_processEventAlert$ev2 = _processEventAlert$ev.category) === null || _processEventAlert$ev2 === void 0 ? void 0 : _processEventAlert$ev2[0];
      if (selectedProcessEventAlertCategory === _constants.DEFAULT_ALERT_FILTER_VALUE) {
        return true;
      }
      return processEventAlertCategory === selectedProcessEventAlertCategory;
    });
  }, [selectedProcessEventAlertCategory, alerts]);
  if (alerts.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: scrollerRef,
    css: styles.container,
    "data-test-subj": "sessionView:sessionViewAlertDetails",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_process_tree_alerts_filter.ProcessTreeAlertsFilter, {
    totalAlertsCount: alerts.length,
    alertTypeCounts: alertTypeCounts,
    filteredAlertsCount: filteredProcessEventAlerts.length,
    onAlertEventCategorySelected: handleProcessEventAlertCategorySelected,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }), filteredProcessEventAlerts.map((alert, idx) => {
    var _alert$kibana2, _alert$kibana2$alert;
    const alertUuid = ((_alert$kibana2 = alert.kibana) === null || _alert$kibana2 === void 0 ? void 0 : (_alert$kibana2$alert = _alert$kibana2.alert) === null || _alert$kibana2$alert === void 0 ? void 0 : _alert$kibana2$alert.uuid) || null;
    return /*#__PURE__*/_react.default.createElement(_process_tree_alert.ProcessTreeAlert, {
      key: `${alertUuid}-${idx}`,
      alert: alert,
      isInvestigated: investigatedAlertId === alertUuid,
      isSelected: isProcessSelected && (selectedAlert === null || selectedAlert === void 0 ? void 0 : selectedAlert.uuid) === alertUuid,
      onClick: handleAlertClick,
      selectAlert: selectAlert,
      onShowAlertDetails: onShowAlertDetails,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 11
      }
    });
  }));
}