"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const configSchema = _configSchema.schema.object({
  // Is this plugin enabled?
  enabled: _configSchema.schema.boolean({
    defaultValue: false
  }),
  // Config namespace for developer-specific settings.
  developer: _configSchema.schema.maybe(_configSchema.schema.object({
    // Settings for the project switcher.  This is now deprecated.
    projectSwitcher: _configSchema.schema.maybe(_configSchema.schema.object({
      // Should the switcher be enabled?
      enabled: _configSchema.schema.conditional(_configSchema.schema.contextRef('dev'), false, _configSchema.schema.boolean({
        validate: rawValue => {
          if (rawValue === true) {
            return 'Switcher can only be enabled in development mode';
          }
        },
        defaultValue: false
      }), _configSchema.schema.boolean({
        defaultValue: true
      })),
      // Which project is currently selected?
      currentType: _configSchema.schema.oneOf([_configSchema.schema.literal('security'), _configSchema.schema.literal('observability'), _configSchema.schema.literal('search'), _configSchema.schema.literal('chat')])
    }))
  }))
});
const config = exports.config = {
  schema: configSchema,
  exposeToBrowser: {
    developer: true
  },
  deprecations: ({
    unused
  }) => [unused('developer', {
    level: 'critical'
  }), unused('developer.projectSwitcher', {
    level: 'critical'
  }), unused('developer.projectSwitcher.enabled', {
    level: 'critical'
  }), unused('developer.projectSwitcher.currentType', {
    level: 'critical'
  })]
};