"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateConnector = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../constants");
var _use_kibana = require("../use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCreateConnector = () => {
  const {
    application: {
      navigateToUrl
    },
    http
  } = (0, _use_kibana.useKibanaServices)();
  const {
    data: connector,
    isLoading,
    isSuccess,
    mutate
  } = (0, _reactQuery.useMutation)({
    mutationFn: async () => {
      const result = await http.post('/internal/serverless_search/connectors');
      return result.connector;
    }
  });
  (0, _react.useEffect)(() => {
    if (isSuccess) {
      navigateToUrl(http.basePath.prepend(`/app/${(0, _reactRouterDom.generatePath)(_constants.EDIT_CONNECTOR_PATH, {
        id: (connector === null || connector === void 0 ? void 0 : connector.id) || ''
      })}`));
    }
  }, [connector, isSuccess, navigateToUrl, http.basePath]);
  const createConnector = () => mutate();
  return {
    createConnector,
    isLoading
  };
};
exports.useCreateConnector = useCreateConnector;