"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorsTable = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _searchConnectors = require("@kbn/search-connectors");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n_string = require("../../../../common/i18n_string");
var _use_connectors = require("../../hooks/api/use_connectors");
var _use_connector_types = require("../../hooks/api/use_connector_types");
var _use_kibana = require("../../hooks/use_kibana");
var _constants = require("../../constants");
var _delete_connector_modal = require("./delete_connector_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/serverless_search/public/application/components/connectors/connectors_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectorsTable = () => {
  var _data$connectors$filt, _data$connectors$leng, _data$connectors$leng2;
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const [query, setQuery] = (0, _react.useState)('');
  const {
    data,
    isError,
    isLoading
  } = (0, _use_connectors.useConnectors)();
  const connectorTypes = (0, _use_connector_types.useConnectorTypes)();
  const {
    application: {
      navigateToUrl
    }
  } = (0, _use_kibana.useKibanaServices)();
  const [filter, setFilter] = (0, _react.useState)('name');
  (0, _react.useEffect)(() => {
    if (query) {
      setPageIndex(0);
    }
  }, [query, filter]);
  if (isError) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.errorFetchingConnectors', {
      defaultMessage: 'We encountered an error fetching your connectors.'
    }));
  }
  const connectedLabel = _i18n.i18n.translate('xpack.serverlessSearch.connectors.connected', {
    defaultMessage: 'Connected'
  });
  const configuredLabel = _i18n.i18n.translate('xpack.serverlessSearch.connectors.configuredLabel', {
    defaultMessage: 'Configured'
  });
  const typeLabel = _i18n.i18n.translate('xpack.serverlessSearch.connectors.typeLabel', {
    defaultMessage: 'Type'
  });
  const nameLabel = _i18n.i18n.translate('xpack.serverlessSearch.connectors.nameLabel', {
    defaultMessage: 'Name'
  });
  const syncStatusLabel = _i18n.i18n.translate('xpack.serverlessSearch.connectors.syncStatusLabel', {
    defaultMessage: 'Sync status'
  });
  const filterOptions = [{
    text: nameLabel,
    value: 'name'
  }, {
    text: typeLabel,
    value: 'service_type'
  }, {
    text: _i18n.i18n.translate('xpack.serverlessSearch.connectors.descriptionLabel', {
      defaultMessage: 'Description'
    }),
    value: 'description'
  }, {
    text: syncStatusLabel,
    value: 'last_sync_status'
  }];
  const columns = [{
    field: 'name',
    name: nameLabel,
    render: (name, connector) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "serverlessSearchColumnsLink",
      onClick: () => navigateToUrl((0, _reactRouterDom.generatePath)(_constants.EDIT_CONNECTOR_PATH, {
        id: connector.id
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 9
      }
    }, name || connector.id),
    truncateText: true
  }, {
    field: 'service_type',
    name: typeLabel,
    render: serviceType => {
      const typeData = connectorTypes.find(connector => connector.serviceType === (serviceType !== null && serviceType !== void 0 ? serviceType : ''));
      if (!typeData) {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "row",
        gutterSize: "s",
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: typeData.iconPath,
        "aria-label": typeData.name,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 135,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 15
        }
      }, typeData.name)));
    }
  }, {
    field: 'status',
    name: connectedLabel,
    render: status => status === _searchConnectors.ConnectorStatus.CONNECTED ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "aria-label": connectedLabel,
      color: "success",
      type: "checkInCircleFilled",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.notConnectedLabel', {
      defaultMessage: 'Not connected'
    }))
  }, {
    field: 'status',
    name: configuredLabel,
    render: status => [_searchConnectors.ConnectorStatus.CONNECTED, _searchConnectors.ConnectorStatus.CONFIGURED].includes(status) ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "aria-label": configuredLabel,
      color: "success",
      type: "checkInCircleFilled",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.notConfiguredLabel', {
      defaultMessage: 'Not configured'
    }))
  }, {
    field: 'last_sync_status',
    name: syncStatusLabel,
    render: syncStatus => syncStatus ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: (0, _searchConnectors.syncStatusToColor)(syncStatus),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 11
      }
    }, (0, _searchConnectors.syncStatusToText)(syncStatus)) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.notSyncedLabel', {
      defaultMessage: 'Not synced'
    }))
  }, {
    field: 'last_sync_status',
    name: syncStatusLabel,
    render: syncStatus => syncStatus ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: (0, _searchConnectors.syncStatusToColor)(syncStatus),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 11
      }
    }, (0, _searchConnectors.syncStatusToText)(syncStatus)) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.notSyncedLabel', {
      defaultMessage: 'Not synced'
    }))
  }, {
    actions: [{
      name: _i18n_string.COPY_CONNECTOR_ID_LABEL,
      description: _i18n_string.COPY_CONNECTOR_ID_LABEL,
      icon: 'copy',
      type: 'icon',
      onClick: connector => (0, _eui.copyToClipboard)(connector.id)
    }, {
      render: connector => /*#__PURE__*/_react.default.createElement(DeleteConnectorModalAction, {
        connector: connector,
        disabled: !(data !== null && data !== void 0 && data.canManageConnectors),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 209,
          columnNumber: 13
        }
      })
    }],
    name: _i18n.i18n.translate('xpack.serverlessSearch.connectors.actionsLabel', {
      defaultMessage: 'Actions'
    })
  }];
  const items = (_data$connectors$filt = data === null || data === void 0 ? void 0 : data.connectors.filter(connector => filter ? `${connector[filter]}`.toLowerCase().includes(query.toLowerCase()) : true).slice(pageIndex * pageSize, (pageIndex + 1) * pageSize)) !== null && _data$connectors$filt !== void 0 ? _data$connectors$filt : [];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    box: {
      'data-test-subj': `serverlessSearchConnectorsTableSearchBar`
    },
    onChange: ({
      queryText
    }) => setQuery(queryText !== null && queryText !== void 0 ? queryText : ''),
    query: query,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "serverlessSearchConnectorsTableSelect",
    onChange: e => setFilter(e.currentTarget.value),
    options: filterOptions,
    "aria-label": _i18n.i18n.translate('xpack.serverlessSearch.connectorsTable.filterSelect.ariaLabel', {
      defaultMessage: 'Filter'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.serverlessSearch.connectorsTable.summaryLabel",
    defaultMessage: "Showing {items} of {count} {connectors}",
    values: {
      connectors: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 260,
          columnNumber: 25
        }
      }, _i18n_string.CONNECTORS_LABEL),
      items: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 262,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: pageIndex * pageSize,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 263,
          columnNumber: 17
        }
      }), "-", /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: pageIndex * pageSize + items.length,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 264,
          columnNumber: 17
        }
      })),
      count: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: (_data$connectors$leng = data === null || data === void 0 ? void 0 : data.connectors.length) !== null && _data$connectors$leng !== void 0 ? _data$connectors$leng : 0,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 267,
          columnNumber: 20
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    style: {
      height: 2
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "serverlessSearchConnectorTable",
    columns: columns,
    loading: isLoading,
    items: items,
    onChange: ({
      page
    }) => {
      if (page) {
        const {
          index,
          size
        } = page;
        setPageIndex(index);
        setPageSize(size);
      }
    },
    pagination: {
      pageIndex,
      pageSize,
      totalItemCount: (_data$connectors$leng2 = data === null || data === void 0 ? void 0 : data.connectors.length) !== null && _data$connectors$leng2 !== void 0 ? _data$connectors$leng2 : 0
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 7
    }
  }));
};
exports.ConnectorsTable = ConnectorsTable;
const DeleteConnectorModalAction = ({
  connector,
  disabled
}) => {
  const [modalIsOpen, setModalIsOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, modalIsOpen && /*#__PURE__*/_react.default.createElement(_delete_connector_modal.DeleteConnectorModal, {
    closeDeleteModal: () => setModalIsOpen(false),
    connectorId: connector.id,
    connectorName: connector.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n_string.DELETE_CONNECTOR_LABEL,
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    disabled: disabled,
    "data-test-subj": "serverlessSearchDeleteConnectorModalActionButton",
    "aria-label": _i18n_string.DELETE_CONNECTOR_LABEL,
    onClick: () => setModalIsOpen(true),
    iconType: "trash",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 9
    }
  })));
};