"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleObjectCorrelations = void 0;
var _get_alert_suppression_usage = require("../usage_utils/get_alert_suppression_usage");
var _get_threat_match_usage = require("../usage_utils/get_threat_match_usage");
var _get_response_actions_usage = require("../usage_utils/get_response_actions_usage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRuleObjectCorrelations = ({
  ruleResults,
  legacyNotificationRuleIds,
  casesRuleIds,
  alertsCounts
}) => {
  return ruleResults.map(result => {
    var _attributes$params$ru, _attributes$params$ru2;
    const ruleId = result.id;
    const {
      attributes
    } = result;

    // Even if the legacy notification is set to "no_actions" we still count the rule as having a legacy notification that is not migrated yet.
    const hasLegacyNotification = legacyNotificationRuleIds.get(ruleId) != null;

    // We only count a rule as having a notification and being "enabled" if it is _not_ set to "no_actions"/"muteAll" and it has at least one action within its array.
    const hasNotification = !hasLegacyNotification && attributes.actions != null && attributes.actions.length > 0 && attributes.muteAll !== true;
    const {
      hasAlertSuppressionPerRuleExecution,
      hasAlertSuppressionPerTimePeriod,
      hasAlertSuppressionMissingFieldsStrategyDoNotSuppress,
      alertSuppressionFieldsCount
    } = (0, _get_alert_suppression_usage.getAlertSuppressionUsage)(attributes);
    const {
      hasResponseActions,
      hasResponseActionsEndpoint,
      hasResponseActionsOsquery
    } = (0, _get_response_actions_usage.getResponseActionsUsage)(attributes);
    return {
      rule_name: attributes.name,
      rule_id: attributes.params.ruleId,
      rule_type: attributes.params.type,
      rule_version: attributes.params.version,
      enabled: attributes.enabled,
      is_customized: ((_attributes$params$ru = attributes.params.ruleSource) === null || _attributes$params$ru === void 0 ? void 0 : _attributes$params$ru.type) === 'external' && ((_attributes$params$ru2 = attributes.params.ruleSource) === null || _attributes$params$ru2 === void 0 ? void 0 : _attributes$params$ru2.isCustomized) === true,
      // if rule immutable, it's Elastic/prebuilt
      elastic_rule: attributes.params.immutable,
      created_on: attributes.createdAt,
      updated_on: attributes.updatedAt,
      alert_count_daily: alertsCounts.get(ruleId) || 0,
      cases_count_total: casesRuleIds.get(ruleId) || 0,
      has_legacy_notification: hasLegacyNotification,
      has_notification: hasNotification,
      has_legacy_investigation_field: Array.isArray(attributes.params.investigationFields),
      has_alert_suppression_per_rule_execution: hasAlertSuppressionPerRuleExecution,
      has_alert_suppression_per_time_period: hasAlertSuppressionPerTimePeriod,
      has_alert_suppression_missing_fields_strategy_do_not_suppress: hasAlertSuppressionMissingFieldsStrategyDoNotSuppress,
      alert_suppression_fields_count: alertSuppressionFieldsCount,
      has_exceptions: attributes.params.exceptionsList != null && attributes.params.exceptionsList.length > 0,
      has_response_actions: hasResponseActions,
      has_response_actions_endpoint: hasResponseActionsEndpoint,
      has_response_actions_osquery: hasResponseActionsOsquery,
      has_does_not_match_condition: (0, _get_threat_match_usage.getThreatMatchUsage)(attributes).hasDoesNotMatchCondition
    };
  });
};
exports.getRuleObjectCorrelations = getRuleObjectCorrelations;