"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEcsMappingNode = void 0;
var _convert_esql_schema_cim_to_ecs = require("../../../../../../../common/task/agent/helpers/convert_esql_schema_cim_to_ecs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEcsMappingNode = params => {
  const convertEsqlSchemaCimToEcs = (0, _convert_esql_schema_cim_to_ecs.getConvertEsqlSchemaCisToEcs)(params);
  return async state => {
    var _state$elastic_rule$t, _state$elastic_rule$d, _state$elastic_rule$q;
    const {
      query,
      comments
    } = await convertEsqlSchemaCimToEcs({
      title: (_state$elastic_rule$t = state.elastic_rule.title) !== null && _state$elastic_rule$t !== void 0 ? _state$elastic_rule$t : '',
      description: (_state$elastic_rule$d = state.elastic_rule.description) !== null && _state$elastic_rule$d !== void 0 ? _state$elastic_rule$d : '',
      query: (_state$elastic_rule$q = state.elastic_rule.query) !== null && _state$elastic_rule$q !== void 0 ? _state$elastic_rule$q : '',
      originalQuery: state.inline_query
    });

    // Set includes_ecs_mapping to indicate that this node has been executed to ensure it only runs once
    return {
      includes_ecs_mapping: true,
      comments,
      ...(query && {
        elastic_rule: {
          ...state.elastic_rule,
          query
        }
      })
    };
  };
};
exports.getEcsMappingNode = getEcsMappingNode;