"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemRuleMigrationsGetMissingPrivilegesRoute = void 0;
var _constants = require("../../../../../../common/siem_migrations/constants");
var _authz = require("../../../common/api/util/authz");
var _with_license = require("../../../common/api/util/with_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemRuleMigrationsGetMissingPrivilegesRoute = (router, logger) => {
  router.versioned.get({
    path: _constants.SIEM_RULE_MIGRATION_MISSING_PRIVILEGES_PATH,
    access: 'internal',
    security: {
      authz: _authz.authz
    }
  }).addVersion({
    version: '1',
    validate: false
  }, (0, _with_license.withLicense)(async (context, request, response) => {
    try {
      const core = await context.core;
      const securitySolution = await context.securitySolution;
      const siemClient = securitySolution === null || securitySolution === void 0 ? void 0 : securitySolution.getAppClient();
      const spaceId = securitySolution === null || securitySolution === void 0 ? void 0 : securitySolution.getSpaceId();
      const esClient = core.elasticsearch.client.asCurrentUser;
      if (!siemClient) {
        return response.notFound();
      }
      const lookupsIndexPattern = `${_constants.LOOKUPS_INDEX_PREFIX}${spaceId}*`;
      const privileges = await readIndexPrivileges(esClient, lookupsIndexPattern);
      const missingPrivileges = [];
      if (!privileges.index[lookupsIndexPattern].read) {
        missingPrivileges.push({
          indexName: lookupsIndexPattern,
          privileges: ['read']
        });
      }
      return response.ok({
        body: missingPrivileges
      });
    } catch (err) {
      logger.error(err);
      return response.badRequest({
        body: err.message
      });
    }
  }));
};
exports.registerSiemRuleMigrationsGetMissingPrivilegesRoute = registerSiemRuleMigrationsGetMissingPrivilegesRoute;
const readIndexPrivileges = async (esClient, index) => {
  const response = await esClient.security.hasPrivileges({
    index: [{
      names: [index],
      privileges: ['read', 'write', 'manage', 'create_index']
    }]
  }, {
    meta: true
  });
  return response.body;
};