"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTranslateSplToEsql = void 0;
var _comments = require("../../../util/comments");
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTranslateSplToEsql = ({
  esqlKnowledgeBase,
  logger
}) => {
  return async input => {
    var _response$match$1$tri, _response$match, _response$match$, _response$match2;
    const splunkQuery = {
      title: input.title,
      description: input.description,
      inline_query: input.inlineQuery
    };
    const prompt = await _prompts.ESQL_SYNTAX_TRANSLATION_PROMPT.format({
      splunk_query: JSON.stringify(splunkQuery, null, 2),
      index_pattern: input.indexPattern,
      task_description: input.taskDescription
    });
    const response = await esqlKnowledgeBase.translate(prompt);
    const esqlQuery = (_response$match$1$tri = (_response$match = response.match(/```esql\n([\s\S]*?)\n```/)) === null || _response$match === void 0 ? void 0 : _response$match[1].trim()) !== null && _response$match$1$tri !== void 0 ? _response$match$1$tri : '';
    if (!esqlQuery) {
      logger.warn('Failed to extract ESQL query from translation response');
      const comment = '## Translation Summary\n\nFailed to extract ESQL query from translation response';
      return {
        comments: [(0, _comments.generateAssistantComment)(comment)]
      };
    }
    const translationSummary = (_response$match$ = (_response$match2 = response.match(/## Translation Summary[\s\S]*$/)) === null || _response$match2 === void 0 ? void 0 : _response$match2[0]) !== null && _response$match$ !== void 0 ? _response$match$ : '';
    return {
      esqlQuery,
      comments: [(0, _comments.generateAssistantComment)((0, _comments.cleanMarkdown)(translationSummary))]
    };
  };
};
exports.getTranslateSplToEsql = getTranslateSplToEsql;