"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SiemMigrationsBaseDataService = void 0;
var _indexAdapter = require("@kbn/index-adapter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TOTAL_FIELDS_LIMIT = 2500;
class SiemMigrationsBaseDataService {
  constructor(kibanaVersion) {
    this.kibanaVersion = kibanaVersion;
  }
  createIndexPatternAdapter({
    name,
    fieldMap
  }) {
    const adapter = new _indexAdapter.IndexPatternAdapter(name, {
      kibanaVersion: this.kibanaVersion,
      totalFieldsLimit: TOTAL_FIELDS_LIMIT
    });
    adapter.setComponentTemplate({
      name,
      fieldMap
    });
    adapter.setIndexTemplate({
      name,
      componentTemplateRefs: [name]
    });
    return adapter;
  }
  createIndexAdapter({
    name,
    fieldMap
  }) {
    const adapter = new _indexAdapter.IndexAdapter(name, {
      kibanaVersion: this.kibanaVersion,
      totalFieldsLimit: TOTAL_FIELDS_LIMIT
    });
    adapter.setComponentTemplate({
      name,
      fieldMap
    });
    adapter.setIndexTemplate({
      name,
      componentTemplateRefs: [name]
    });
    return adapter;
  }
  getAdapterIndexName(adapterId) {
    return `${this.baseIndexName}-${adapterId}`;
  }
  createIndexNameProvider(adapter, spaceId) {
    return async () => {
      await adapter.createIndex(spaceId); // This will resolve instantly when the index is already created
      return adapter.getIndexName(spaceId);
    };
  }
}
exports.SiemMigrationsBaseDataService = SiemMigrationsBaseDataService;