"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.disablePrivilegeMonitoringEngineRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../common/constants");
var _assert_advanced_setting_enabled = require("../../utils/assert_advanced_setting_enabled");
var _status_service = require("../engine/status_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const disablePrivilegeMonitoringEngineRoute = (router, logger) => {
  router.versioned.post({
    access: 'public',
    path: _constants.MONITORING_ENGINE_DISABLE_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    },
    options: {
      availability: {
        since: '9.1.0',
        stability: 'stable'
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {}
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const secSol = await context.securitySolution;
    await (0, _assert_advanced_setting_enabled.assertAdvancedSettingsEnabled)(await context.core, _constants.ENABLE_PRIVILEGED_USER_MONITORING_SETTING);
    try {
      const dataClient = secSol.getPrivilegeMonitoringDataClient();
      const soClient = dataClient.getScopedSoClient(request);
      const statusService = (0, _status_service.createEngineStatusService)(dataClient, soClient);
      const body = await statusService.disable();
      return response.ok({
        body
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      logger.error(`Error disabling privilege monitoring engine: ${error.message}`);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.disablePrivilegeMonitoringEngineRoute = disablePrivilegeMonitoringEngineRoute;