"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldRunSourceMigrationFactory = void 0;
var _utils = require("../../../../../../common/entity_analytics/privileged_user_monitoring/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const shouldRunSourceMigrationFactory = deps => async namespace => {
  const response = await deps.esClient.count({
    index: (0, _utils.getPrivilegedMonitorUsersIndex)(namespace),
    query: {
      bool: {
        must: [{
          exists: {
            field: 'labels.source_indices' // find users that have the source_indices field
          }
        }]
      }
    }
  });
  return response.count > 0;
};
exports.shouldRunSourceMigrationFactory = shouldRunSourceMigrationFactory;