"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initEntityUpdatesDataStream = exports.getEntityUpdatesDataStreamStatus = exports.getEntityUpdatesDataStreamName = exports.deleteEntityUpdatesDataStreams = void 0;
var _patterns = require("@kbn/entities-schema/src/schema/v1/patterns");
var _entity_store = require("../../../../../common/api/entity_analytics/entity_store");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initEntityUpdatesDataStream = async (entityType, esClient, namespace) => {
  await esClient.indices.createDataStream({
    name: getEntityUpdatesDataStreamName(entityType, namespace)
  });
};
exports.initEntityUpdatesDataStream = initEntityUpdatesDataStream;
const deleteEntityUpdatesDataStreams = async (entityType, esClient, namespace) => {
  await esClient.indices.deleteDataStream({
    name: getEntityUpdatesDataStreamName(entityType, namespace)
  }, {
    ignore: [404]
  });
};
exports.deleteEntityUpdatesDataStreams = deleteEntityUpdatesDataStreams;
const getEntityUpdatesDataStreamStatus = async (entityType, esClient, namespace) => {
  var _resp$data_streams;
  const index = getEntityUpdatesDataStreamName(entityType, namespace);
  const resp = await esClient.indices.getDataStream({
    name: index
  }, {
    ignore: [404]
  });
  const exists = ((_resp$data_streams = resp.data_streams) === null || _resp$data_streams === void 0 ? void 0 : _resp$data_streams.length) > 0;
  return {
    id: index,
    installed: exists,
    resource: _entity_store.EngineComponentResourceEnum.data_stream
  };
};
exports.getEntityUpdatesDataStreamStatus = getEntityUpdatesDataStreamStatus;
const getEntityUpdatesDataStreamName = (type, namespace) => {
  return (0, _patterns.entitiesIndexPattern)({
    schemaVersion: _patterns.ENTITY_SCHEMA_VERSION_V1,
    dataset: _patterns.ENTITY_UPDATES,
    definitionId: `security_${type}_${namespace}`
  });
};
exports.getEntityUpdatesDataStreamName = getEntityUpdatesDataStreamName;