"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapSOErrorsToBulkErrors = exports.mapSOErrorToBulkError = void 0;
var _utils = require("../../../../../routes/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapSOErrorsToBulkErrors = errors => {
  return errors.map(error => mapSOErrorToBulkError(error));
};
exports.mapSOErrorsToBulkErrors = mapSOErrorsToBulkErrors;
const mapSOErrorToBulkError = error => {
  switch (error.error.type) {
    case 'conflict':
    case 'ambiguous_conflict':
      return (0, _utils.createBulkErrorObject)({
        id: error.id,
        statusCode: 409,
        message: `Saved Object already exists`
      });
    case 'unsupported_type':
      return (0, _utils.createBulkErrorObject)({
        id: error.id,
        statusCode: 400,
        message: 'Unsupported SO action type'
      });
    case 'missing_references':
      return (0, _utils.createBulkErrorObject)({
        id: error.id,
        statusCode: 400,
        message: 'Missing SO references'
      });
    case 'unknown':
      return (0, _utils.createBulkErrorObject)({
        id: error.id,
        statusCode: error.error.statusCode,
        message: `Unknown Saved Object import error: ${error.error.message}`
      });
  }
};
exports.mapSOErrorToBulkError = mapSOErrorToBulkError;