"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TimelineDataTableComponent = exports.TimelineDataTable = exports.SAMPLE_SIZE_SETTING = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _constants = require("../../../../../../common/constants");
var _use_on_expandable_flyout_close = require("../../../../../flyout/shared/hooks/use_on_expandable_flyout_close");
var _panel_keys = require("../../../../../flyout/document_details/shared/constants/panel_keys");
var _selectors = require("../../../../store/selectors");
var _timeline = require("../../../../../../common/api/timeline");
var _helpers = require("../../../../../common/lib/cell_actions/helpers");
var _stateful_event_context = require("../../../../../common/components/events_viewer/stateful_event_context");
var _kibana = require("../../../../../common/lib/kibana");
var _constants2 = require("../../../../../app/actions/constants");
var _formatted_field_udt = require("../../body/renderers/formatted_field_udt");
var _toolbar_additional_controls = _interopRequireDefault(require("./toolbar_additional_controls"));
var _styles = require("../styles");
var _store = require("../../../../store");
var _utils = require("../utils");
var _timeline_event_detail_row = require("./timeline_event_detail_row");
var _custom_timeline_data_grid_body = require("./custom_timeline_data_grid_body");
var _constants3 = require("../../body/constants");
var _types = require("../../../../../common/lib/telemetry/types");
var _get_row_indicator = require("./get_row_indicator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/unified_components/data_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SAMPLE_SIZE_SETTING = exports.SAMPLE_SIZE_SETTING = 500;
const DataGridMemoized = /*#__PURE__*/_react.default.memo(_unifiedDataTable.UnifiedDataTable);
const TimelineDataTableComponent = exports.TimelineDataTableComponent = /*#__PURE__*/(0, _react.memo)(function TimelineDataTableMemo({
  columns,
  columnIds,
  dataView,
  activeTab,
  timelineId,
  itemsPerPage,
  itemsPerPageOptions,
  rowRenderers,
  sort,
  events,
  isSortEnabled = true,
  onFieldEdited,
  refetch,
  dataLoadingState,
  totalCount,
  onFetchMoreRecords,
  updatedAt,
  isTextBasedQuery = false,
  onSetColumns,
  onSort,
  onFilter,
  leadingControlColumns,
  onUpdatePageIndex
}) {
  const dispatch = (0, _reactRedux.useDispatch)();

  // Store context in state rather than creating object in provider value={} to prevent re-renders caused by a new object being created
  const [activeStatefulEventContext] = (0, _react.useState)({
    timelineID: timelineId,
    enableHostDetailsFlyout: true,
    enableIpDetailsFlyout: true,
    tabType: activeTab
  });
  const {
    services: {
      uiSettings,
      fieldFormats,
      storage,
      dataViewFieldEditor,
      notifications: {
        toasts: toastsService
      },
      telemetry,
      theme,
      data: dataPluginContract
    }
  } = (0, _kibana.useKibana)();
  const [expandedDoc, setExpandedDoc] = (0, _react.useState)();
  const onCloseExpandableFlyout = (0, _react.useCallback)(id => {
    setExpandedDoc(prev => !prev ? prev : undefined);
  }, []);
  const {
    closeFlyout,
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  (0, _use_on_expandable_flyout_close.useOnExpandableFlyoutClose)({
    callback: onCloseExpandableFlyout
  });
  const showTimeCol = (0, _react.useMemo)(() => !!dataView && !!dataView.timeFieldName, [dataView]);
  const {
    rowHeight,
    sampleSize,
    excludedRowRendererIds,
    columns: timelineColumns
  } = (0, _reactRedux.useSelector)(state => (0, _selectors.selectTimelineById)(state, timelineId));
  const settings = (0, _react.useMemo)(() => {
    const _columns = {};
    timelineColumns.forEach(timelineColumn => {
      var _timelineColumn$initi;
      _columns[timelineColumn.id] = {
        width: (_timelineColumn$initi = timelineColumn.initialWidth) !== null && _timelineColumn$initi !== void 0 ? _timelineColumn$initi : undefined
      };
    });
    return {
      columns: _columns
    };
  }, [timelineColumns]);
  const {
    tableRows,
    tableStylesOverride
  } = (0, _react.useMemo)(() => (0, _utils.transformTimelineItemToUnifiedRows)({
    events,
    dataView
  }), [events, dataView]);
  const handleOnEventDetailPanelOpened = (0, _react.useCallback)(eventData => {
    var _eventData$ecs$_index;
    openFlyout({
      right: {
        id: _panel_keys.DocumentDetailsRightPanelKey,
        params: {
          id: eventData._id,
          indexName: (_eventData$ecs$_index = eventData.ecs._index) !== null && _eventData$ecs$_index !== void 0 ? _eventData$ecs$_index : '',
          scopeId: timelineId
        }
      }
    });
    telemetry.reportEvent(_types.DocumentEventTypes.DetailsFlyoutOpened, {
      location: timelineId,
      panel: 'right'
    });
  }, [openFlyout, timelineId, telemetry]);
  const onSetExpandedDoc = (0, _react.useCallback)(newDoc => {
    if (newDoc) {
      const timelineDoc = tableRows.find(r => r.id === newDoc.id);
      setExpandedDoc(timelineDoc);
      if (timelineDoc) {
        handleOnEventDetailPanelOpened(timelineDoc);
      }
    } else {
      closeFlyout();
      setExpandedDoc(undefined);
    }
  }, [tableRows, handleOnEventDetailPanelOpened, closeFlyout]);
  const onResizeDataGrid = (0, _react.useCallback)(colSettings => {
    if (colSettings.width) {
      dispatch(_store.timelineActions.updateColumnWidth({
        columnId: colSettings.columnId,
        id: timelineId,
        width: Math.round(colSettings.width)
      }));
    }
  }, [dispatch, timelineId]);
  const onChangeItemsPerPage = (0, _react.useCallback)(itemsChangedPerPage => {
    dispatch(_store.timelineActions.updateItemsPerPage({
      id: timelineId,
      itemsPerPage: itemsChangedPerPage
    }));
  }, [dispatch, timelineId]);
  const customColumnRenderers = (0, _react.useMemo)(() => (0, _formatted_field_udt.getFormattedFields)({
    dataTableRows: tableRows,
    scopeId: 'timeline',
    headers: columns
  }), [columns, tableRows]);
  const handleFetchMoreRecords = (0, _react.useCallback)(() => {
    onFetchMoreRecords();
  }, [onFetchMoreRecords]);
  const additionalControls = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_toolbar_additional_controls.default, {
    timelineId: timelineId,
    updatedAt: updatedAt,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 13
    }
  }), [timelineId, updatedAt]);
  const cellActionsMetadata = (0, _react.useMemo)(() => ({
    scopeId: timelineId
  }), [timelineId]);
  const onUpdateSampleSize = (0, _react.useCallback)(newSampleSize => {
    if (newSampleSize !== sampleSize) {
      dispatch(_store.timelineActions.updateSampleSize({
        id: timelineId,
        sampleSize: newSampleSize
      }));
    }
  }, [dispatch, sampleSize, timelineId]);
  const onUpdateRowHeight = (0, _react.useCallback)(newRowHeight => {
    if (newRowHeight !== rowHeight) {
      dispatch(_store.timelineActions.updateRowHeight({
        id: timelineId,
        rowHeight: newRowHeight
      }));
    }
  }, [dispatch, rowHeight, timelineId]);
  const dataGridServices = (0, _react.useMemo)(() => {
    return {
      theme,
      fieldFormats,
      storage,
      toastNotifications: toastsService,
      uiSettings,
      dataViewFieldEditor,
      data: dataPluginContract
    };
  }, [theme, fieldFormats, storage, toastsService, uiSettings, dataViewFieldEditor, dataPluginContract]);
  const enabledRowRenderers = (0, _react.useMemo)(() => {
    if (excludedRowRendererIds && excludedRowRendererIds.length === _timeline.RowRendererCount) return [];
    if (!excludedRowRendererIds) return rowRenderers;
    return rowRenderers.filter(rowRenderer => !excludedRowRendererIds.includes(rowRenderer.id));
  }, [excludedRowRendererIds, rowRenderers]);
  const TimelineEventDetailRowRendererComp = (0, _react.useMemo)(() => function TimelineEventDetailRowRenderer(props) {
    const {
      rowIndex,
      ...restProps
    } = props;
    return /*#__PURE__*/_react.default.createElement(_timeline_event_detail_row.TimelineEventDetailRow, (0, _extends2.default)({
      event: tableRows[rowIndex],
      rowIndex: rowIndex,
      timelineId: timelineId,
      enabledRowRenderers: enabledRowRenderers
    }, restProps, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 310,
        columnNumber: 13
      }
    }));
  }, [tableRows, timelineId, enabledRowRenderers]);

  /**
   * Ref: https://eui.elastic.co/#/tabular-content/data-grid-advanced#custom-body-renderer
   */
  const trailingControlColumns = (0, _react.useMemo)(() => [{
    id: _constants3.TIMELINE_EVENT_DETAIL_ROW_ID,
    width: 0,
    // The header cell should be visually hidden, but available to screen readers
    headerCellRender: () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
    headerCellProps: {
      className: 'euiScreenReaderOnly'
    },
    // The footer cell can be hidden to both visual & SR users, as it does not contain meaningful information
    footerCellProps: {
      style: {
        display: 'none'
      }
    },
    rowCellRender: _constants.JEST_ENVIRONMENT ? TimelineEventDetailRowRendererComp : /*#__PURE__*/_react.default.memo(TimelineEventDetailRowRendererComp)
  }], [TimelineEventDetailRowRendererComp]);

  /**
   * Ref: https://eui.elastic.co/#/tabular-content/data-grid-advanced#custom-body-renderer
   */
  const renderCustomBodyCallback = (0, _react.useCallback)(({
    Cell,
    visibleRowData,
    visibleColumns,
    setCustomGridBodyProps,
    gridWidth,
    headerRow,
    footerRow
  }) => /*#__PURE__*/_react.default.createElement(_custom_timeline_data_grid_body.CustomTimelineDataGridBody, {
    rows: tableRows,
    Cell: Cell,
    visibleColumns: visibleColumns,
    visibleRowData: visibleRowData,
    headerRow: headerRow,
    footerRow: footerRow,
    setCustomGridBodyProps: setCustomGridBodyProps,
    enabledRowRenderers: enabledRowRenderers,
    rowHeight: rowHeight,
    gridWidth: gridWidth,
    refetch: refetch,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 9
    }
  }), [tableRows, enabledRowRenderers, rowHeight, refetch]);
  const finalRenderCustomBodyCallback = (0, _react.useMemo)(() => {
    return enabledRowRenderers.length > 0 ? renderCustomBodyCallback : undefined;
  }, [enabledRowRenderers.length, renderCustomBodyCallback]);
  const finalTrailControlColumns = (0, _react.useMemo)(() => {
    return enabledRowRenderers.length > 0 ? trailingControlColumns : undefined;
  }, [enabledRowRenderers.length, trailingControlColumns]);
  return /*#__PURE__*/_react.default.createElement(_stateful_event_context.StatefulEventContext.Provider, {
    value: activeStatefulEventContext,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.StyledTimelineUnifiedDataTable, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 385,
      columnNumber: 9
    }
  }, (dataLoadingState === _unifiedDataTable.DataLoadingState.loading || dataLoadingState === _unifiedDataTable.DataLoadingState.loadingMore) && /*#__PURE__*/_react.default.createElement(_styles.StyledEuiProgress, {
    "data-test-subj": "discoverDataGridUpdating",
    size: "xs",
    color: "accent",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 388,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_styles.UnifiedTimelineGlobalStyles, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 390,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(DataGridMemoized, {
    ariaLabelledBy: "timelineDocumentsAriaLabel",
    className: "udtTimeline",
    columns: columnIds,
    expandedDoc: expandedDoc,
    gridStyleOverride: tableStylesOverride,
    dataView: dataView,
    showColumnTokens: true,
    loadingState: dataLoadingState,
    onFilter: onFilter,
    onResize: onResizeDataGrid,
    onSetColumns: onSetColumns,
    onSort: !isTextBasedQuery ? onSort : undefined,
    rows: tableRows,
    sampleSizeState: sampleSize || 500,
    onUpdateSampleSize: onUpdateSampleSize,
    setExpandedDoc: onSetExpandedDoc,
    showTimeCol: showTimeCol,
    isSortEnabled: isSortEnabled,
    sort: sort,
    rowHeightState: rowHeight,
    isPlainRecord: isTextBasedQuery,
    rowsPerPageState: itemsPerPage,
    onUpdateRowsPerPage: onChangeItemsPerPage,
    onUpdateRowHeight: onUpdateRowHeight,
    onFieldEdited: onFieldEdited,
    cellActionsTriggerId: _constants2.SecurityCellActionsTrigger.DEFAULT,
    services: dataGridServices,
    visibleCellActions: 3,
    externalCustomRenderers: customColumnRenderers,
    renderDocumentView: _helpers.EmptyComponent,
    rowsPerPageOptions: itemsPerPageOptions,
    showFullScreenButton: false,
    maxDocFieldsDisplayed: 50,
    consumer: "timeline",
    totalHits: totalCount,
    onFetchMoreRecords: handleFetchMoreRecords,
    configRowHeight: 3,
    showMultiFields: true,
    cellActionsMetadata: cellActionsMetadata,
    externalAdditionalControls: additionalControls,
    renderCustomGridBody: finalRenderCustomBodyCallback,
    trailingControlColumns: finalTrailControlColumns,
    externalControlColumns: leadingControlColumns,
    onUpdatePageIndex: onUpdatePageIndex,
    getRowIndicator: _get_row_indicator.getTimelineRowTypeIndicator,
    settings: settings,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 11
    }
  })));
});
const TimelineDataTable = exports.default = exports.TimelineDataTable = /*#__PURE__*/_react.default.memo(TimelineDataTableComponent);

// eslint-disable-next-line import/no-default-export