"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEventTypeRowClassName = void 0;
var _helpers = require("../../body/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEventTypeRowClassName = ecsData => {
  const eventType = (0, _helpers.getEventType)(ecsData);
  const eventTypeClassName = eventType === 'eql' ? (0, _helpers.isEvenEqlSequence)(ecsData) ? 'eqlSequence' : 'eqlNonSequence' : eventType === 'raw' ? 'rawEvent' : 'nonRawEvent';
  const buildingBlockTypeClassName = (0, _helpers.isEventBuildingBlockType)(ecsData) ? 'buildingBlockType' : '';
  return `${eventTypeClassName} ${buildingBlockTypeClassName}`.trim();
};
exports.getEventTypeRowClassName = getEventTypeRowClassName;