"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../../common/cti/constants");
var _draggables = require("../../../../../../common/components/draggables");
var _formatted_field = require("../formatted_field");
var _helpers = require("./helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/cti/indicator_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const IndicatorDetails = ({
  contextId,
  eventId,
  feedName,
  indicatorReference,
  indicatorType,
  scopeId
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "flexStart",
  "data-test-subj": "threat-match-indicator-details",
  direction: "row",
  justifyContent: "center",
  gutterSize: "none",
  wrap: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 38,
    columnNumber: 3
  }
}, indicatorType && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 47,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  scopeId: scopeId,
  contextId: contextId,
  "data-test-subj": "threat-match-indicator-details-indicator-type",
  eventId: eventId,
  field: _constants.INDICATOR_MATCHED_TYPE,
  value: indicatorType,
  isAggregatable: true,
  fieldType: 'keyword',
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 48,
    columnNumber: 9
  }
})), feedName && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  component: "span",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 62,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_helpers.HorizontalSpacer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 63,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  defaultMessage: "provided by",
  id: "xpack.securitySolution.alerts.rowRenderers.cti.threatMatch.providerPreposition",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 64,
    columnNumber: 13
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 70,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  contextId: contextId,
  scopeId: scopeId,
  "data-test-subj": "threat-match-indicator-details-indicator-feedName",
  eventId: eventId,
  field: _constants.FEED_NAME,
  value: feedName,
  isAggregatable: true,
  fieldType: 'keyword',
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 71,
    columnNumber: 11
  }
}))), indicatorReference && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 86,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_helpers.HorizontalSpacer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 87,
    columnNumber: 11
  }
}, ':')), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 89,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_formatted_field.FormattedFieldValue, {
  contextId: contextId,
  "data-test-subj": "threat-match-indicator-details-indicator-reference",
  eventId: eventId,
  fieldName: _constants.INDICATOR_REFERENCE,
  value: indicatorReference,
  isAggregatable: true,
  fieldType: 'keyword',
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 90,
    columnNumber: 11
  }
}))));
exports.IndicatorDetails = IndicatorDetails;