"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEditTimelineBatchActions = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _timeline = require("../../../../common/api/timeline");
var i18n = _interopRequireWildcard(require("./translations"));
var _export_timeline = require("./export_timeline");
var _edit_timeline_actions = require("./edit_timeline_actions");
var _ = require(".");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/open_timeline/edit_timeline_batch_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useEditTimelineBatchActions = ({
  deleteTimelines,
  selectedItems,
  tableRef,
  timelineType = _timeline.TimelineTypeEnum.default
}) => {
  const {
    enableExportTimelineDownloader,
    disableExportTimelineDownloader,
    isEnableDownloader,
    isDeleteTimelineModalOpen,
    onOpenDeleteTimelineModal,
    onCloseDeleteTimelineModal
  } = (0, _edit_timeline_actions.useEditTimelineActions)();
  const onCompleteBatchActions = (0, _react.useCallback)(closePopover => {
    if (closePopover != null) closePopover();
    if (tableRef != null && tableRef.current != null) {
      tableRef.current.changeSelection([]);
    }
    disableExportTimelineDownloader();
    onCloseDeleteTimelineModal();
  }, [disableExportTimelineDownloader, onCloseDeleteTimelineModal, tableRef]);
  const {
    timelineIds,
    searchIds
  } = (0, _react.useMemo)(() => {
    if (selectedItems != null) {
      return (0, _.getRequestIds)((0, _.getSelectedTimelineIdsAndSearchIds)(selectedItems));
    } else {
      return {
        timelineIds: [],
        searchIds: undefined
      };
    }
  }, [selectedItems]);
  const handleEnableExportTimelineDownloader = (0, _react.useCallback)(() => enableExportTimelineDownloader(), [enableExportTimelineDownloader]);
  const handleOnOpenDeleteTimelineModal = (0, _react.useCallback)(() => onOpenDeleteTimelineModal(), [onOpenDeleteTimelineModal]);
  const getBatchItemsPopoverContent = (0, _react.useCallback)(closePopover => {
    var _selectedItems$length, _selectedItems$length2, _selectedItems$0$titl, _selectedItems$;
    const disabled = selectedItems == null || selectedItems.length === 0;
    const items = [];
    if (selectedItems) {
      items.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": "export-timeline-action",
        disabled: disabled,
        icon: "exportAction",
        key: "ExportItemKey",
        onClick: handleEnableExportTimelineDownloader,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 11
        }
      }, i18n.EXPORT_SELECTED));
    }
    if (deleteTimelines) {
      items.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": "delete-timeline-action",
        disabled: disabled,
        icon: "trash",
        key: "DeleteItemKey",
        onClick: handleOnOpenDeleteTimelineModal,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 11
        }
      }, i18n.DELETE_SELECTED));
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_export_timeline.EditTimelineActions, {
      deleteTimelines: deleteTimelines,
      ids: timelineIds,
      savedSearchIds: searchIds,
      isEnableDownloader: isEnableDownloader,
      isDeleteTimelineModalOpen: isDeleteTimelineModalOpen,
      onComplete: onCompleteBatchActions.bind(null, closePopover),
      title: (selectedItems === null || selectedItems === void 0 ? void 0 : selectedItems.length) !== 1 ? timelineType === _timeline.TimelineTypeEnum.template ? i18n.SELECTED_TEMPLATES((_selectedItems$length = selectedItems === null || selectedItems === void 0 ? void 0 : selectedItems.length) !== null && _selectedItems$length !== void 0 ? _selectedItems$length : 0) : i18n.SELECTED_TIMELINES((_selectedItems$length2 = selectedItems === null || selectedItems === void 0 ? void 0 : selectedItems.length) !== null && _selectedItems$length2 !== void 0 ? _selectedItems$length2 : 0) : (_selectedItems$0$titl = (_selectedItems$ = selectedItems[0]) === null || _selectedItems$ === void 0 ? void 0 : _selectedItems$.title) !== null && _selectedItems$0$titl !== void 0 ? _selectedItems$0$titl : '',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      items: items,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 11
      }
    }));
  }, [selectedItems, deleteTimelines, timelineIds, searchIds, isEnableDownloader, isDeleteTimelineModalOpen, onCompleteBatchActions, timelineType, handleEnableExportTimelineDownloader, handleOnOpenDeleteTimelineModal]);
  return {
    onCompleteBatchActions,
    getBatchItemsPopoverContent
  };
};
exports.useEditTimelineBatchActions = useEditTimelineBatchActions;