"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveTimelineModal = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _selectors = require("../../../store/selectors");
var _shared_imports = require("../../../../shared_imports");
var _timeline = require("../../../../../common/types/timeline");
var _timeline2 = require("../../../../../common/api/timeline");
var _store = require("../../../store");
var commonI18n = _interopRequireWildcard(require("../../timeline/properties/translations"));
var i18n = _interopRequireWildcard(require("./translations"));
var _use_start_transaction = require("../../../../common/lib/apm/use_start_transaction");
var _user_actions = require("../../../../common/lib/apm/user_actions");
var _use_create_timeline = require("../../../hooks/use_create_timeline");
var _notes_size = require("../../timeline/properties/notes_size");
var _schema = require("./schema");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/modal/actions/save_timeline_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CommonUseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const descriptionLabel = `${i18n.TIMELINE_DESCRIPTION} (${i18n.OPTIONAL})`;
/**
 * This component renders the modal to save a timeline with title, description, save as new timeline switch and save / cancel buttons
 */
const SaveTimelineModal = exports.SaveTimelineModal = /*#__PURE__*/_react.default.memo(({
  closeSaveTimeline,
  initialFocusOn,
  timelineId,
  showWarning
}) => {
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    isSaving,
    description,
    status,
    title,
    timelineType
  } = (0, _reactRedux.useSelector)(state => (0, _selectors.selectTimelineById)(state, timelineId));
  const [saveAsNewTimeline, setSaveAsNewTimeline] = (0, _react.useState)(false);
  const onSaveAsNewChanged = (0, _react.useCallback)(e => setSaveAsNewTimeline(e.target.checked), []);
  const isUnsaved = status === _timeline2.TimelineStatusEnum.draft;
  const prevIsSaving = (0, _usePrevious.default)(isSaving);

  // Resetting the timeline by replacing the active one with a new empty one
  const resetTimeline = (0, _use_create_timeline.useCreateTimeline)({
    timelineId: _timeline.TimelineId.active,
    timelineType: _timeline2.TimelineTypeEnum.default
  });
  const handleSubmit = (0, _react.useCallback)((titleAndDescription, isValid) => {
    if (isValid) {
      dispatch(_store.timelineActions.updateTitleAndDescription({
        id: timelineId,
        ...titleAndDescription
      }));
      dispatch(_store.timelineActions.saveTimeline({
        id: timelineId,
        saveAsNew: saveAsNewTimeline
      }));
    }
    return Promise.resolve();
  }, [dispatch, timelineId, saveAsNewTimeline]);
  const initialState = (0, _react.useMemo)(() => ({
    title,
    description
  }), [title, description]);
  const {
    form
  } = (0, _shared_imports.useForm)({
    id: 'timelineTitleAndDescriptionForm',
    schema: _schema.formSchema,
    onSubmit: handleSubmit,
    options: {
      stripEmptyFields: false
    },
    defaultValue: initialState
  });
  const {
    isSubmitted,
    isSubmitting,
    submit
  } = form;
  const onSubmit = (0, _react.useCallback)(() => {
    startTransaction({
      name: _user_actions.TIMELINE_ACTIONS.SAVE
    });
    submit();
  }, [submit, startTransaction]);

  // When the form is cancelled and we're showing the discard warning,
  // reset the timeline and close the modal.
  const handleCancel = (0, _react.useCallback)(async () => {
    if (showWarning) {
      await resetTimeline();
    }
    closeSaveTimeline();
  }, [closeSaveTimeline, resetTimeline, showWarning]);
  const closeModalText = (0, _react.useMemo)(() => {
    if (status === _timeline2.TimelineStatusEnum.draft && showWarning) {
      return timelineType === _timeline2.TimelineTypeEnum.template ? i18n.DISCARD_TIMELINE_TEMPLATE : i18n.DISCARD_TIMELINE;
    }
    return i18n.CLOSE_MODAL;
  }, [showWarning, status, timelineType]);
  const modalHeader = (0, _react.useMemo)(() => status === _timeline2.TimelineStatusEnum.draft ? timelineType === _timeline2.TimelineTypeEnum.template ? i18n.SAVE_TIMELINE_TEMPLATE : i18n.SAVE_TIMELINE : timelineType === _timeline2.TimelineTypeEnum.template ? i18n.NAME_TIMELINE_TEMPLATE : i18n.SAVE_TIMELINE, [status, timelineType]);
  const saveButtonTitle = (0, _react.useMemo)(() => status === _timeline2.TimelineStatusEnum.draft && showWarning ? timelineType === _timeline2.TimelineTypeEnum.template ? i18n.SAVE_TIMELINE_TEMPLATE : i18n.SAVE_TIMELINE : i18n.SAVE, [showWarning, status, timelineType]);
  const calloutMessage = (0, _react.useMemo)(() => i18n.UNSAVED_TIMELINE_WARNING(timelineType), [timelineType]);
  const titleFieldProps = (0, _react.useMemo)(() => ({
    'aria-label': i18n.TIMELINE_TITLE,
    autoFocus: initialFocusOn === 'title',
    'data-test-subj': 'save-timeline-modal-title-input',
    disabled: isSaving,
    spellCheck: true,
    placeholder: timelineType === _timeline2.TimelineTypeEnum.template ? commonI18n.UNTITLED_TEMPLATE : commonI18n.UNTITLED_TIMELINE
  }), [initialFocusOn, isSaving, timelineType]);
  const descriptionFieldProps = (0, _react.useMemo)(() => ({
    'aria-label': i18n.TIMELINE_DESCRIPTION,
    'data-test-subj': 'save-timeline-modal-description-input',
    disabled: isSaving,
    placeholder: commonI18n.DESCRIPTION
  }), [isSaving]);
  (0, _react.useEffect)(() => {
    if (isSubmitted && !isSaving && prevIsSaving) {
      closeSaveTimeline();
    }
  }, [isSubmitted, isSaving, prevIsSaving, closeSaveTimeline]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "data-test-subj": "save-timeline-modal",
    maxWidth: _notes_size.NOTES_PANEL_WIDTH,
    onClose: closeSaveTimeline,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 7
    }
  }, isSaving && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "s",
    color: "primary",
    position: "absolute",
    "data-test-subj": "progress-bar",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    "data-test-subj": "save-timeline-modal-header",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 9
    }
  }, modalHeader), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 9
    }
  }, showWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: calloutMessage,
    color: "danger",
    iconType: "warning",
    "data-test-subj": "save-timeline-modal-callout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "title",
    fullWidth: true,
    label: i18n.TITLE,
    euiFieldProps: titleFieldProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    label: descriptionLabel,
    path: "description",
    fullWidth: true,
    euiFieldProps: descriptionFieldProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 15
    }
  }, !isUnsaved ? /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: i18n.SAVE_AS_NEW,
    checked: saveAsNewTimeline,
    onChange: onSaveAsNewChanged,
    "data-test-subj": "save-timeline-modal-save-as-new-switch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 19
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    component: "span",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    fill: false,
    onClick: handleCancel,
    isDisabled: isSaving,
    "data-test-subj": "save-timeline-modal-close-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 21
    }
  }, closeModalText)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    component: "span",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    autoFocus: initialFocusOn === 'save',
    size: "s",
    isDisabled: isSaving || isSubmitting,
    fill: true,
    onClick: onSubmit,
    "data-test-subj": "save-timeline-modal-save-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 21
    }
  }, saveButtonTitle))))))));
});
SaveTimelineModal.displayName = 'SaveTimelineModal';