"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useReadinessTasksStats = void 0;
var _react = require("react");
var _siemReadiness = require("@kbn/siem-readiness");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useReadinessTasksStats = () => {
  const {
    getLatestTasks
  } = (0, _siemReadiness.useReadinessTasks)();
  const readinessTasksStats = (0, _react.useMemo)(() => {
    const latestTasksData = getLatestTasks.data || [];
    const completedTaskIds = new Set(latestTasksData.filter(task => task.status === 'completed').map(task => task.task_id));
    const pillarStatsMap = {
      visibility: {
        completed: 0,
        total: 0
      },
      detection: {
        completed: 0,
        total: 0
      },
      response: {
        completed: 0,
        total: 0
      }
    };
    _siemReadiness.READINESS_TASKS.forEach(task => {
      pillarStatsMap[task.pillar].total++;
      if (completedTaskIds.has(task.id)) {
        pillarStatsMap[task.pillar].completed++;
      }
    });
    const totalTasks = _siemReadiness.READINESS_TASKS.length;
    const totalCompleted = Object.values(pillarStatsMap).reduce((sum, stat) => sum + stat.completed, 0);
    const totalIncomplete = totalTasks - totalCompleted;
    return {
      pillarStatsMap,
      totalCompleted,
      totalTasks,
      totalIncomplete
    };
  }, [getLatestTasks]);
  return {
    readinessTasksStats
  };
};
exports.useReadinessTasksStats = useReadinessTasksStats;