"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesDataInputSubSteps = exports.RulesDataInput = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _components = require("../../../../../common/components");
var _get_eui_step_status = require("../../../../../common/utils/get_eui_step_status");
var _kibana = require("../../../../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../constants");
var _copy_export_query = require("./sub_steps/copy_export_query");
var _rules_file_upload = require("./sub_steps/rules_file_upload");
var _check_resources = require("./sub_steps/check_resources");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/components/data_input_flyout/steps/rules/rules_data_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RulesDataInput = exports.RulesDataInput = /*#__PURE__*/_react.default.memo(({
  dataInputStep,
  migrationStats,
  onMigrationCreated,
  onMissingResourcesFetched
}) => {
  const dataInputStatus = (0, _react.useMemo)(() => (0, _get_eui_step_status.getEuiStepStatus)(_constants.DataInputStep.Rules, dataInputStep), [dataInputStep]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "center",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStepNumber, {
    titleSize: "xs",
    number: _constants.DataInputStep.Rules,
    status: dataInputStatus,
    "data-test-subj": "rulesDataInputStepNumber",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "rulesDataInputTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 19
    }
  }, i18n.RULES_DATA_INPUT_TITLE))))), dataInputStatus === 'current' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(RulesDataInputSubSteps, {
    migrationStats: migrationStats,
    onMigrationCreated: onMigrationCreated,
    onMissingResourcesFetched: onMissingResourcesFetched,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 15
    }
  }))));
});
RulesDataInput.displayName = 'RulesDataInput';
const END = 10;
const RulesDataInputSubSteps = exports.RulesDataInputSubSteps = /*#__PURE__*/_react.default.memo(({
  migrationStats,
  onMigrationCreated,
  onMissingResourcesFetched
}) => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services.siemMigrations.rules;
  const [subStep, setSubStep] = (0, _react.useState)(migrationStats ? 4 : 1);
  const [migrationName, setMigrationName] = (0, _react.useState)(migrationStats === null || migrationStats === void 0 ? void 0 : migrationStats.name);
  const [isRulesFileReady, setIsRuleFileReady] = (0, _react.useState)(false);

  // Migration name step
  const setName = (0, _react.useCallback)(name => {
    setMigrationName(name);
    if (name) {
      setSubStep(isRulesFileReady ? 3 : 2);
    } else {
      setSubStep(1);
    }
  }, [isRulesFileReady]);
  const nameStep = (0, _components.useMigrationNameStep)({
    status: (0, _get_eui_step_status.getEuiStepStatus)(1, subStep),
    setMigrationName: setName,
    migrationName
  });

  // Copy query step
  const onCopied = (0, _react.useCallback)(() => {
    setSubStep(currentSubStep => currentSubStep !== 1 ? 3 : currentSubStep); // Move to the next step only if step 1 was completed
    telemetry.reportSetupQueryCopied({
      migrationId: migrationStats === null || migrationStats === void 0 ? void 0 : migrationStats.id
    });
  }, [telemetry, migrationStats === null || migrationStats === void 0 ? void 0 : migrationStats.id]);
  const copyStep = (0, _copy_export_query.useCopyExportQueryStep)({
    status: (0, _get_eui_step_status.getEuiStepStatus)(2, subStep),
    onCopied
  });

  // Upload rules step
  const onMigrationCreatedStep = (0, _react.useCallback)(stats => {
    onMigrationCreated(stats);
    setSubStep(4);
  }, [onMigrationCreated]);
  const onRulesFileChanged = (0, _react.useCallback)(files => {
    setIsRuleFileReady(!!(files !== null && files !== void 0 && files.length));
    setSubStep(3);
  }, []);
  const uploadStep = (0, _rules_file_upload.useRulesFileUploadStep)({
    status: (0, _get_eui_step_status.getEuiStepStatus)(3, subStep),
    migrationStats,
    onRulesFileChanged,
    onMigrationCreated: onMigrationCreatedStep,
    migrationName
  });

  // Check missing resources step
  const onMissingResourcesFetchedStep = (0, _react.useCallback)(missingResources => {
    onMissingResourcesFetched(missingResources);
    setSubStep(END);
  }, [onMissingResourcesFetched]);
  const resourcesStep = (0, _check_resources.useCheckResourcesStep)({
    status: (0, _get_eui_step_status.getEuiStepStatus)(4, subStep),
    migrationStats,
    onMissingResourcesFetched: onMissingResourcesFetchedStep
  });
  const steps = (0, _react.useMemo)(() => [nameStep, copyStep, uploadStep, resourcesStep], [nameStep, copyStep, uploadStep, resourcesStep]);
  return /*#__PURE__*/_react.default.createElement(_components.SubSteps, {
    steps: steps,
    "data-test-subj": "migrationsSubSteps",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 12
    }
  });
});
RulesDataInputSubSteps.displayName = 'RulesDataInputActive';