"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUpdatedColumn = exports.SIEM_DASHBOARDS_MIGRATIONS_UPDATED_HEADER_ID = void 0;
var _react = _interopRequireDefault(require("react"));
var _formatted_date = require("../../../../common/components/formatted_date");
var i18n = _interopRequireWildcard(require("./translations"));
var _components = require("../../../common/components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/dashboards/components/dashboard_table_columns/updated.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SIEM_DASHBOARDS_MIGRATIONS_UPDATED_HEADER_ID = exports.SIEM_DASHBOARDS_MIGRATIONS_UPDATED_HEADER_ID = 'siemDashboardsMigrationsUpdatedHeader';
const createUpdatedColumn = () => {
  return {
    field: 'original_dashboard.last_updated',
    name: /*#__PURE__*/_react.default.createElement(_components.TableHeader, {
      id: SIEM_DASHBOARDS_MIGRATIONS_UPDATED_HEADER_ID,
      title: i18n.COLUMN_UPDATED,
      tooltipContent: i18n.UPDATE_COLUMN_TOOLTIP,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 21,
        columnNumber: 7
      }
    }),
    render: value => /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
      value: value,
      dateFormat: "M/D/YY",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 7
      }
    }),
    sortable: true,
    truncateText: true,
    align: 'left',
    width: '15%'
  };
};
exports.createUpdatedColumn = createUpdatedColumn;