"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.upsertDashboardMigrationResources = exports.updateDashboardMigration = exports.stopDashboardMigration = exports.startDashboardMigration = exports.installMigrationDashboards = exports.getMigrationDashboards = exports.getDashboardMigrationTranslationStats = exports.getDashboardMigrationStats = exports.getDashboardMigrationResources = exports.getDashboardMigrationMissingResources = exports.getDashboardMigrationAllStats = exports.getDashboardMigration = exports.deleteDashboardMigration = exports.createDashboardMigration = exports.addDashboardsToDashboardMigration = void 0;
var _shared = require("@kbn/openapi-common/shared");
var _constants = require("../../../../common/siem_migrations/dashboards/constants");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VERSION = '1';
const createDashboardMigration = async ({
  signal,
  name
}) => {
  return _kibana.KibanaServices.get().http.put(_constants.SIEM_DASHBOARD_MIGRATIONS_PATH, {
    version: VERSION,
    signal,
    body: JSON.stringify({
      name
    })
  });
};
exports.createDashboardMigration = createDashboardMigration;
const getDashboardMigration = async ({
  migrationId,
  signal
}) => {
  return _kibana.KibanaServices.get().http.get((0, _shared.replaceParams)(_constants.SIEM_DASHBOARD_MIGRATION_PATH, {
    migration_id: migrationId
  }), {
    version: VERSION,
    signal
  });
};
exports.getDashboardMigration = getDashboardMigration;
const getDashboardMigrationStats = async ({
  migrationId,
  signal
}) => {
  // Typed with `DashboardMigrationStats` instead of `GetDashboardMigrationStatsResponse` to use native enums instead of the zod enum
  return _kibana.KibanaServices.get().http.get((0, _shared.replaceParams)(_constants.SIEM_DASHBOARD_MIGRATION_STATS_PATH, {
    migration_id: migrationId
  }), {
    version: VERSION,
    signal
  });
};

/**
 * Retrieves the translation stats for the migration.
 */
exports.getDashboardMigrationStats = getDashboardMigrationStats;
const getDashboardMigrationTranslationStats = async ({
  migrationId,
  signal
}) => {
  return _kibana.KibanaServices.get().http.get((0, _shared.replaceParams)(_constants.SIEM_DASHBOARD_MIGRATION_TRANSLATION_STATS_PATH, {
    migration_id: migrationId
  }), {
    version: '1',
    signal
  });
};
exports.getDashboardMigrationTranslationStats = getDashboardMigrationTranslationStats;
const updateDashboardMigration = async ({
  migrationId,
  body,
  signal
}) => {
  return _kibana.KibanaServices.get().http.patch((0, _shared.replaceParams)(_constants.SIEM_DASHBOARD_MIGRATION_PATH, {
    migration_id: migrationId
  }), {
    version: VERSION,
    signal,
    body: JSON.stringify(body)
  });
};
exports.updateDashboardMigration = updateDashboardMigration;
/** Retrieves all the migration dashboard documents of a specific migration. */
const getMigrationDashboards = async ({
  migrationId,
  page,
  perPage,
  sortField,
  sortDirection,
  filters,
  signal
}) => {
  return _kibana.KibanaServices.get().http.get((0, _shared.replaceParams)(_constants.SIEM_DASHBOARD_MIGRATION_DASHBOARDS_PATH, {
    migration_id: migrationId
  }), {
    version: '1',
    query: {
      page,
      per_page: perPage,
      sort_field: sortField,
      sort_direction: sortDirection,
      search_term: filters === null || filters === void 0 ? void 0 : filters.searchTerm,
      ids: filters === null || filters === void 0 ? void 0 : filters.ids,
      is_installed: filters === null || filters === void 0 ? void 0 : filters.installed,
      is_fully_translated: filters === null || filters === void 0 ? void 0 : filters.fullyTranslated,
      is_partially_translated: filters === null || filters === void 0 ? void 0 : filters.partiallyTranslated,
      is_untranslatable: filters === null || filters === void 0 ? void 0 : filters.untranslatable,
      is_failed: filters === null || filters === void 0 ? void 0 : filters.failed
    },
    signal
  });
};
exports.getMigrationDashboards = getMigrationDashboards;
const addDashboardsToDashboardMigration = async ({
  migrationId,
  body,
  signal
}) => {
  return _kibana.KibanaServices.get().http.post((0, _shared.replaceParams)(_constants.SIEM_DASHBOARD_MIGRATION_DASHBOARDS_PATH, {
    migration_id: migrationId
  }), {
    version: VERSION,
    body: JSON.stringify(body),
    signal
  });
};
exports.addDashboardsToDashboardMigration = addDashboardsToDashboardMigration;
/** Installs the provided dashboard ids for a specific migration. */
const installMigrationDashboards = async ({
  migrationId,
  ids,
  signal
}) => {
  return _kibana.KibanaServices.get().http.post((0, _shared.replaceParams)(_constants.SIEM_DASHBOARD_MIGRATION_INSTALL_PATH, {
    migration_id: migrationId
  }), {
    version: '1',
    body: JSON.stringify({
      ids
    }),
    signal
  });
};

// --- Resources
exports.installMigrationDashboards = installMigrationDashboards;
const getDashboardMigrationMissingResources = async ({
  migrationId,
  signal
}) => {
  return _kibana.KibanaServices.get().http.get((0, _shared.replaceParams)(_constants.SIEM_DASHBOARD_MIGRATION_RESOURCES_MISSING_PATH, {
    migration_id: migrationId
  }), {
    version: VERSION,
    signal
  });
};
exports.getDashboardMigrationMissingResources = getDashboardMigrationMissingResources;
const upsertDashboardMigrationResources = async ({
  migrationId,
  body,
  signal
}) => {
  return _kibana.KibanaServices.get().http.post((0, _shared.replaceParams)(_constants.SIEM_DASHBOARD_MIGRATION_RESOURCES_PATH, {
    migration_id: migrationId
  }), {
    version: VERSION,
    body: JSON.stringify(body),
    signal
  });
};
exports.upsertDashboardMigrationResources = upsertDashboardMigrationResources;
const getDashboardMigrationResources = async ({
  migrationId,
  signal
}) => {
  return _kibana.KibanaServices.get().http.get((0, _shared.replaceParams)(_constants.SIEM_DASHBOARD_MIGRATION_RESOURCES_PATH, {
    migration_id: migrationId
  }), {
    version: VERSION,
    signal
  });
};

////////////
// / Task
///////////
exports.getDashboardMigrationResources = getDashboardMigrationResources;
const startDashboardMigration = async ({
  migrationId,
  signal,
  settings: {
    connectorId
  },
  retry,
  langSmithOptions
}) => {
  const body = {
    settings: {
      connector_id: connectorId
    },
    langsmith_options: langSmithOptions,
    retry
  };
  return _kibana.KibanaServices.get().http.post((0, _shared.replaceParams)(_constants.SIEM_DASHBOARD_MIGRATION_START_PATH, {
    migration_id: migrationId
  }), {
    version: VERSION,
    signal,
    body: JSON.stringify(body)
  });
};
exports.startDashboardMigration = startDashboardMigration;
const stopDashboardMigration = async ({
  migrationId,
  signal
}) => {
  return _kibana.KibanaServices.get().http.post((0, _shared.replaceParams)(_constants.SIEM_DASHBOARD_MIGRATION_STOP_PATH, {
    migration_id: migrationId
  }), {
    version: VERSION,
    signal
  });
};
exports.stopDashboardMigration = stopDashboardMigration;
const getDashboardMigrationAllStats = async ({
  signal
}) => {
  // Typed with `DashboardMigrationStats` instead of `GetAllDashboardMigrationsStatsResponse` to use native enums instead of the zod enum
  return _kibana.KibanaServices.get().http.get(_constants.SIEM_DASHBOARD_MIGRATIONS_ALL_STATS_PATH, {
    version: VERSION,
    signal
  });
};
exports.getDashboardMigrationAllStats = getDashboardMigrationAllStats;
const deleteDashboardMigration = async ({
  migrationId,
  signal
}) => {
  return _kibana.KibanaServices.get().http.delete((0, _shared.replaceParams)(_constants.SIEM_DASHBOARD_MIGRATION_PATH, {
    migration_id: migrationId
  }), {
    version: VERSION,
    signal
  });
};
exports.deleteDashboardMigration = deleteDashboardMigration;