"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STOP_SUCCESS = exports.STOP_ERROR = void 0;
exports.useStopSiemMigration = useStopSiemMigration;
var _react = require("react");
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _kibana_react = require("../../../common/lib/kibana/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const STOP_SUCCESS = exports.STOP_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.service.stopMigrationSuccess', {
  defaultMessage: 'Migration stopped successfully.'
});
const STOP_ERROR = exports.STOP_ERROR = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.service.stopMigrationError', {
  defaultMessage: 'Error stopping migration.'
});
function useStopSiemMigration(migrationType, {
  onSuccess
} = {}) {
  const {
    siemMigrations
  } = (0, _kibana_react.useKibana)().services;
  const {
    addSuccess,
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const stopMigration = (0, _react.useCallback)(migrationId => {
    if (migrationType === 'rule') {
      return siemMigrations.rules.stopRuleMigration(migrationId);
    } else {
      return siemMigrations.dashboards.stopDashboardMigration(migrationId);
    }
  }, [siemMigrations, migrationType]);
  return (0, _reactQuery.useMutation)({
    mutationKey: ['siemMigration', migrationType, 'stop'],
    mutationFn: async ({
      migrationId
    }) => {
      return stopMigration(migrationId);
    },
    onSuccess: result => {
      if (result.stopped) {
        addSuccess(STOP_SUCCESS);
      }
      onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess();
    },
    onError: e => {
      addError(e, {
        title: STOP_ERROR
      });
    }
  });
}