"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAiValueFilteredLinks = exports.aiValueLinks = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _translations = require("../app/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const aiValueLinks = exports.aiValueLinks = {
  id: _constants.SecurityPageName.aiValue,
  title: _translations.AI_VALUE_DASHBOARD,
  description: _i18n.i18n.translate('xpack.securitySolution.appLinks.aiValueDescription', {
    defaultMessage: 'See ROI for Security AI features'
  }),
  path: _constants.AI_VALUE_PATH,
  capabilities: [[`${_constants.SECURITY_FEATURE_ID}.show`, `${_constants.ATTACK_DISCOVERY_FEATURE_ID}.attack-discovery`]],
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.aiValue', {
    defaultMessage: 'AI Value'
  })],
  globalNavPosition: 8
};

/**
 * Filters the Value report link based on user roles.
 * Only admin and soc_manager roles are allowed to see this link in the complete tier.
 */
const getAiValueFilteredLinks = async (_core, plugins) => {
  const currentUser = await plugins.security.authc.getCurrentUser();
  if (!currentUser) {
    return null;
  }
  const userRoles = currentUser.roles || [];
  const allowedRoles = ['admin', 'soc_manager', '_search_ai_lake_soc_manager'];
  const hasRequiredRole = allowedRoles.some(role => userRoles.includes(role));
  return hasRequiredRole ? aiValueLinks : null;
};
exports.getAiValueFilteredLinks = getAiValueFilteredLinks;