"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.overviewLinks = exports.entityAnalyticsLinks = exports.ecsDataQualityDashboardLinks = exports.detectionResponseLinks = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _translations = require("../app/translations");
var _overview_page = _interopRequireDefault(require("../common/images/overview_page.png"));
var _data_quality_dashboard_page = _interopRequireDefault(require("../common/images/data_quality_dashboard_page.png"));
var _detection_response_page = _interopRequireDefault(require("../common/images/detection_response_page.png"));
var _entity_analytics_dashboard = _interopRequireDefault(require("../common/images/entity_analytics_dashboard.png"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const overviewLinks = exports.overviewLinks = {
  id: _constants.SecurityPageName.overview,
  title: _translations.OVERVIEW,
  landingImage: _overview_page.default,
  description: _i18n.i18n.translate('xpack.securitySolution.appLinks.overviewDescription', {
    defaultMessage: 'Summary of your security environment activity, including alerts, events, recent items, and a news feed!'
  }),
  path: _constants.OVERVIEW_PATH,
  capabilities: [`${_constants.SECURITY_FEATURE_ID}.show`],
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.overview', {
    defaultMessage: 'Overview'
  })]
};
const detectionResponseLinks = exports.detectionResponseLinks = {
  id: _constants.SecurityPageName.detectionAndResponse,
  title: _translations.DETECTION_RESPONSE,
  landingImage: _detection_response_page.default,
  description: _i18n.i18n.translate('xpack.securitySolution.appLinks.detectionAndResponseDescription', {
    defaultMessage: 'Information about your Alerts and Cases within the Security Solution, including Hosts and Users with Alerts.'
  }),
  path: _constants.DETECTION_RESPONSE_PATH,
  capabilities: [`${_constants.SECURITY_FEATURE_ID}.show`],
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.detectionAndResponse', {
    defaultMessage: 'Detection & Response'
  })]
};
const entityAnalyticsLinks = exports.entityAnalyticsLinks = {
  id: _constants.SecurityPageName.entityAnalytics,
  title: _translations.ENTITY_ANALYTICS,
  landingImage: _entity_analytics_dashboard.default,
  description: _i18n.i18n.translate('xpack.securitySolution.appLinks.entityAnalyticsDescription', {
    defaultMessage: 'Entity analytics, anomalies, and threats to narrow down the monitoring surface area.'
  }),
  path: _constants.ENTITY_ANALYTICS_PATH,
  capabilities: [`${_constants.SECURITY_FEATURE_ID}.entity-analytics`],
  isBeta: false,
  licenseType: 'platinum',
  globalSearchKeywords: [_translations.ENTITY_ANALYTICS]
};
const ecsDataQualityDashboardLinks = exports.ecsDataQualityDashboardLinks = {
  id: _constants.SecurityPageName.dataQuality,
  title: _translations.DATA_QUALITY,
  landingImage: _data_quality_dashboard_page.default,
  description: _i18n.i18n.translate('xpack.securitySolution.appLinks.ecsDataQualityDashboardDescription', {
    defaultMessage: 'Check index mappings and values for compatibility with the Elastic Common Schema (ECS)'
  }),
  path: _constants.DATA_QUALITY_PATH,
  capabilities: [`${_constants.SECURITY_FEATURE_ID}.show`],
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.ecsDataQualityDashboard', {
    defaultMessage: 'Data Quality'
  })]
};