"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeviceControlNotifyUserOption = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _empty_value = require("../../../../../../common/components/empty_value");
var _use_license = require("../../../../../../common/hooks/use_license");
var _setting_card = require("./setting_card");
var _types = require("../../../../../../../common/endpoint/types");
var _policy_config = require("../../../../../../../common/endpoint/models/policy_config");
var _use_get_custom_notification_unavailable_component = require("../hooks/use_get_custom_notification_unavailable_component");
var _shared_translations = require("./shared_translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/policy_settings_form/components/device_control_notify_user_option.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DeviceControlNotifyUserOption = exports.DeviceControlNotifyUserOption = /*#__PURE__*/_react.default.memo(({
  policy,
  onChange,
  mode,
  'data-test-subj': dataTestSubj
}) => {
  var _policy$windows$devic, _policy$mac$device_co, _policy$windows$devic2, _policy$mac$device_co2, _policy$windows$popup, _policy$windows$popup2;
  const isEnterprise = (0, _use_license.useLicense)().isEnterprise();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const CustomNotificationUpsellingComponent = (0, _use_get_custom_notification_unavailable_component.useGetCustomNotificationUnavailableComponent)();
  const isEditMode = mode === 'edit';
  const isDeviceControlEnabled = ((_policy$windows$devic = policy.windows.device_control) === null || _policy$windows$devic === void 0 ? void 0 : _policy$windows$devic.enabled) || ((_policy$mac$device_co = policy.mac.device_control) === null || _policy$mac$device_co === void 0 ? void 0 : _policy$mac$device_co.enabled) || false;
  const currentAccessLevel = ((_policy$windows$devic2 = policy.windows.device_control) === null || _policy$windows$devic2 === void 0 ? void 0 : _policy$windows$devic2.usb_storage) || ((_policy$mac$device_co2 = policy.mac.device_control) === null || _policy$mac$device_co2 === void 0 ? void 0 : _policy$mac$device_co2.usb_storage);
  const userNotificationSelected = ((_policy$windows$popup = policy.windows.popup.device_control) === null || _policy$windows$popup === void 0 ? void 0 : _policy$windows$popup.enabled) || false;
  const userNotificationMessage = ((_policy$windows$popup2 = policy.windows.popup.device_control) === null || _policy$windows$popup2 === void 0 ? void 0 : _policy$windows$popup2.message) || '';
  const handleUserNotificationCheckbox = (0, _react.useCallback)(event => {
    const newPayload = (0, _lodash.cloneDeep)(policy);

    // Update Windows popup device control
    newPayload.windows.popup.device_control = newPayload.windows.popup.device_control || {
      enabled: event.target.checked,
      message: _policy_config.DefaultPolicyDeviceNotificationMessage
    };
    newPayload.windows.popup.device_control.enabled = event.target.checked;

    // Update Mac popup device control
    newPayload.mac.popup.device_control = newPayload.mac.popup.device_control || {
      enabled: event.target.checked,
      message: _policy_config.DefaultPolicyDeviceNotificationMessage
    };
    newPayload.mac.popup.device_control.enabled = event.target.checked;
    onChange({
      isValid: true,
      updatedPolicy: newPayload
    });
  }, [policy, onChange]);
  const handleCustomUserNotification = (0, _react.useCallback)(event => {
    const newPayload = (0, _lodash.cloneDeep)(policy);
    // Update Windows popup device control message
    newPayload.windows.popup.device_control = newPayload.windows.popup.device_control || {
      enabled: false,
      message: event.target.value
    };
    newPayload.windows.popup.device_control.message = event.target.value;

    // Update Mac popup device control message
    newPayload.mac.popup.device_control = newPayload.mac.popup.device_control || {
      enabled: false,
      message: event.target.value
    };
    newPayload.mac.popup.device_control.message = event.target.value;
    onChange({
      isValid: true,
      updatedPolicy: newPayload
    });
  }, [policy, onChange]);
  const customNotificationComponent = (0, _react.useMemo)(() => {
    if (!userNotificationSelected) {
      return null;
    }
    if (CustomNotificationUpsellingComponent) {
      return /*#__PURE__*/_react.default.createElement(CustomNotificationUpsellingComponent, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 16
        }
      });
    }
    if (!isEditMode) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("h4", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 15
        }
      }, _shared_translations.NOTIFICATION_MESSAGE_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, userNotificationMessage || (0, _empty_value.getEmptyValue)()));
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      "data-test-subj": getTestId('customMessageTitle'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 17
      }
    }, _shared_translations.CUSTOMIZE_NOTIFICATION_MESSAGE_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "right",
      "data-test-subj": getTestId('tooltipInfo'),
      anchorProps: {
        'data-test-subj': getTestId('tooltipIcon')
      },
      content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.policyDetailsConfig.deviceControl.notifyUserTooltip.a",
        defaultMessage: "Selecting the user notification option will display a notification to the host user when device access is blocked or restricted.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 144,
          columnNumber: 21
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 21
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.policyDetailsConfig.deviceControl.notifyUserTooltip.c",
        defaultMessage: "The user notification can be customized in the text box below. Bracketed tags can be used to dynamically populate the applicable action and device type.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 21
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
      value: userNotificationMessage,
      onChange: handleCustomUserNotification,
      fullWidth: true,
      disabled: !isEditMode,
      "data-test-subj": getTestId('customMessage'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 11
      }
    }));
  }, [CustomNotificationUpsellingComponent, getTestId, handleCustomUserNotification, isEditMode, userNotificationMessage, userNotificationSelected]);
  if (!isEnterprise) {
    return null;
  }
  if (currentAccessLevel !== _types.DeviceControlAccessLevel.deny_all) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": getTestId(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_setting_card.SettingCardHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 13
    }
  }, _shared_translations.NOTIFY_USER_SECTION_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: 'DeviceControlNotifyUserOptionCheckbox',
    "data-test-subj": getTestId('checkbox'),
    label: _shared_translations.NOTIFY_USER_CHECKBOX_LABEL,
    checked: userNotificationSelected,
    disabled: !isEnterprise || !isDeviceControlEnabled || !isEditMode,
    onChange: handleUserNotificationCheckbox,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 9
    }
  }), customNotificationComponent);
});
DeviceControlNotifyUserOption.displayName = 'DeviceControlNotifyUserOption';