"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyArtifactsDeleteModal = void 0;
var _eui = require("@elastic/eui");
var _reactQuery = require("@kbn/react-query");
var _react = _interopRequireWildcard(require("react"));
var _artifacts = require("../../../../../hooks/artifacts");
var _kibana = require("../../../../../../common/lib/kibana");
var _artifacts2 = require("../../../../../../../common/endpoint/service/artifacts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/artifacts/delete_modal/policy_artifacts_delete_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// eslint-disable-next-line react/display-name
const PolicyArtifactsDeleteModal = exports.PolicyArtifactsDeleteModal = /*#__PURE__*/_react.default.memo(({
  policyId,
  policyName,
  apiClient,
  exception,
  onClose,
  labels
}) => {
  const toasts = (0, _kibana.useToasts)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    mutate: updateArtifact,
    isLoading: isUpdateArtifactLoading
  } = (0, _artifacts.useBulkUpdateArtifact)(apiClient, {
    onSuccess: () => {
      toasts.addSuccess({
        title: labels.deleteModalSuccessMessageTitle,
        text: labels.deleteModalSuccessMessageText(exception, policyName)
      });
      queryClient.invalidateQueries(['list', apiClient]);
      onClose();
    },
    onError: error => {
      toasts.addError(error, {
        title: labels.deleteModalErrorMessage
      });
    }
  });
  const handleModalConfirm = (0, _react.useCallback)(() => {
    const modifiedException = {
      ...exception,
      tags: exception.tags.filter(tag => tag !== `${_artifacts2.BY_POLICY_ARTIFACT_TAG_PREFIX}${policyId}`)
    };
    updateArtifact([modifiedException]);
  }, [exception, policyId, updateArtifact]);
  const handleOnClose = (0, _react.useCallback)(() => {
    if (!isUpdateArtifactLoading) {
      onClose();
    }
  }, [isUpdateArtifactLoading, onClose]);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: labels.deleteModalTitle,
    titleProps: {
      id: modalTitleId
    },
    onCancel: handleOnClose,
    onConfirm: handleModalConfirm,
    cancelButtonText: labels.deleteModalCancelButtonTitle,
    confirmButtonText: labels.deleteModalSubmitButtonTitle,
    isLoading: isUpdateArtifactLoading,
    "data-test-subj": 'remove-from-policy-dialog',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "question",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }, labels.deleteModalImpactInfo)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, labels.deleteModalConfirmInfo)));
});