"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArgumentSelectorWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_input_command = require("../../../hooks/state_selectors/use_input_command");
var _use_console_state_dispatch = require("../../../hooks/state_selectors/use_console_state_dispatch");
var _use_with_command_argument_state = require("../../../hooks/state_selectors/use_with_command_argument_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/command_input/components/argument_selector_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ArgumentSelectorWrapperContainer = _styledComponents.default.span`
  border: ${({
  theme: {
    eui
  }
}) => eui.euiBorderThin};
  border-radius: ${({
  theme: {
    eui
  }
}) => eui.euiBorderRadiusSmall};
  overflow: hidden;
  user-select: none;

  .flexGroup {
    align-items: stretch;
  }

  .selectorContainer {
    padding: 0 ${({
  theme: {
    eui
  }
}) => eui.euiSizeXS};
    max-width: 25vw;
    display: flex;
    align-items: center;
    height: 100%;
  }

  .argNameContainer {
    background-color: ${({
  theme: {
    eui
  }
}) => eui.euiFormInputGroupLabelBackground};
  }

  .argName {
    padding-left: ${({
  theme: {
    eui
  }
}) => eui.euiSizeXS};
    height: 100%;
    display: flex;
    align-items: center;
    white-space: nowrap;
  }
`;

// Type to ensure that `SelectorComponent` is defined

/**
 * handles displaying a custom argument value selector and manages its state
 */
const ArgumentSelectorWrapper = exports.ArgumentSelectorWrapper = /*#__PURE__*/(0, _react.memo)(({
  argName,
  argIndex,
  argDefinition: {
    SelectorComponent
  }
}) => {
  const dispatch = (0, _use_console_state_dispatch.useConsoleStateDispatch)();
  const command = (0, _use_input_command.useInputCommand)();
  const {
    valueText,
    value,
    store
  } = (0, _use_with_command_argument_state.useWithCommandArgumentState)(argName, argIndex);
  if (!command) {
    // FIXME: PT we should not throw here as that would likely crash the UI.
    throw new Error('ArgumentSelectorWrapper should only be used when a command is entered');
  }

  // Create requestFocus callback that uses proper console dispatch instead of direct state manipulation
  const requestFocus = (0, _react.useCallback)(() => {
    dispatch({
      type: 'addFocusToKeyCapture'
    });
  }, [dispatch]);
  const handleSelectorComponentOnChange = (0, _react.useCallback)(updates => {
    dispatch({
      type: 'updateInputCommandArgState',
      payload: {
        name: argName,
        instance: argIndex,
        state: updates
      }
    });
  }, [argIndex, argName, dispatch]);
  return /*#__PURE__*/_react.default.createElement(ArgumentSelectorWrapperContainer, {
    className: "eui-displayInlineBlock",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "flexGroup",
    responsive: false,
    alignItems: "center",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "argNameContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "argName",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 15
    }
  }, `--${argName}=`))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "selectorContainer noThemeOverrides eui-textTruncate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(SelectorComponent, {
    value: value,
    valueText: valueText !== null && valueText !== void 0 ? valueText : '',
    argName: argName,
    argIndex: argIndex,
    store: store,
    command: command,
    requestFocus: requestFocus,
    onChange: handleSelectorComponentOnChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  })))));
});
ArgumentSelectorWrapper.displayName = 'ArgumentSelectorWrapper';