"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttackDiscoverySection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _attack_discovery_widget = require("./attack_discovery_widget");
var _ = require("..");
var _context = require("../context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/ai_for_soc/components/attack_discovery_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ATTACK_DISCOVERY = _i18n.i18n.translate('xpack.securitySolution.alertSummary.attackDiscoverySection.title', {
  defaultMessage: 'Attack Discovery'
});

/**
 * Panel to be displayed in AI for SOC alert summary flyout
 */
const AttackDiscoverySection = exports.AttackDiscoverySection = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    eventId
  } = (0, _context.useAIForSOCDetailsContext)();
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _.ATTACK_DISCOVERY_SECTION_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 9
    }
  }, ATTACK_DISCOVERY)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_attack_discovery_widget.AttackDiscoveryWidget, {
    alertId: eventId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }));
});
AttackDiscoverySection.displayName = 'AttackDiscoverySection';