"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IPsQueryTabBody = void 0;
var _react = _interopRequireWildcard(require("react"));
var _network_top_n_flow_table = require("../../components/network_top_n_flow_table");
var _network_top_n_flow = require("../../containers/network_top_n_flow");
var _manage_query = require("../../../../common/components/page/manage_query");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/pages/navigation/ips_query_tab_body.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NetworkTopNFlowTableManage = (0, _manage_query.manageQuery)(_network_top_n_flow_table.NetworkTopNFlowTable);
const IPsQueryTabBody = ({
  endDate,
  filterQuery,
  flowTarget,
  indexNames,
  ip,
  setQuery,
  skip,
  startDate,
  type
}) => {
  const queryId = `${_network_top_n_flow.ID}-${flowTarget}-${type}`;
  const {
    toggleStatus
  } = (0, _query_toggle.useQueryToggle)(queryId);
  const [querySkip, setQuerySkip] = (0, _react.useState)(skip || !toggleStatus);
  (0, _react.useEffect)(() => {
    setQuerySkip(skip || !toggleStatus);
  }, [skip, toggleStatus]);
  const [loading, {
    id,
    inspect,
    isInspected,
    loadPage,
    networkTopNFlow,
    refetch,
    totalCount
  }] = (0, _network_top_n_flow.useNetworkTopNFlow)({
    endDate,
    flowTarget,
    filterQuery,
    id: queryId,
    indexNames,
    ip,
    skip: querySkip,
    startDate,
    type
  });
  return /*#__PURE__*/_react.default.createElement(NetworkTopNFlowTableManage, {
    data: networkTopNFlow,
    flowTargeted: flowTarget,
    id: id,
    inspect: inspect,
    isInspect: isInspected,
    loading: loading,
    loadPage: loadPage,
    refetch: refetch,
    setQuery: setQuery,
    setQuerySkip: setQuerySkip,
    totalCount: totalCount,
    type: type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  });
};
exports.IPsQueryTabBody = IPsQueryTabBody;
IPsQueryTabBody.displayName = 'IPsQueryTabBody';