"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedUsersFileUploader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../../../../common/lib/kibana");
var _telemetry = require("../../../../../common/lib/telemetry");
var _api = require("../../../../api/api");
var _reducer = require("./reducer");
var _hooks = require("./hooks");
var _helpers = require("./helpers");
var _file_picker_step = require("./components/file_picker_step");
var _validation_step = require("./components/validation_step");
var _error_step = require("./components/error_step");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring_onboarding/components/file_uploader/privileged_users_file_uploader.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PrivilegedUsersFileUploader = ({
  onFileUploaded,
  onClose
}) => {
  const [state, dispatch] = (0, _react.useReducer)(_reducer.reducer, _reducer.INITIAL_STATE);
  const {
    uploadPrivilegedUserMonitoringFile
  } = (0, _api.useEntityAnalyticsRoutes)();
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const onValidationComplete = (0, _react.useCallback)(({
    validatedFile,
    processingStartTime,
    processingEndTime,
    tookMs
  }) => {
    telemetry.reportEvent(_telemetry.EntityEventTypes.PrivilegedUserMonitoringCsvPreviewGenerated, {
      file: {
        size: validatedFile.size
      },
      processing: {
        startTime: processingStartTime,
        endTime: processingEndTime,
        tookMs
      },
      stats: {
        validLines: validatedFile.validLines.count,
        invalidLines: validatedFile.invalidLines.count,
        totalLines: validatedFile.validLines.count + validatedFile.invalidLines.count
      }
    });
    dispatch({
      type: 'fileValidated',
      payload: {
        validatedFile: {
          name: validatedFile.name,
          size: validatedFile.size,
          validLines: {
            text: validatedFile.validLines.text,
            count: validatedFile.validLines.count
          },
          invalidLines: {
            text: validatedFile.invalidLines.text,
            count: validatedFile.invalidLines.count,
            errors: validatedFile.invalidLines.errors
          }
        }
      }
    });
  }, [telemetry]);
  const onValidationError = (0, _react.useCallback)(message => {
    dispatch({
      type: 'fileError',
      payload: {
        message
      }
    });
  }, []);
  const validateFile = (0, _hooks.useFileValidation)({
    onError: onValidationError,
    onComplete: onValidationComplete
  });
  const goToFirstStep = (0, _react.useCallback)(() => {
    dispatch({
      type: 'resetState'
    });
  }, []);
  const onFileChange = (0, _react.useCallback)(fileList => {
    const file = fileList === null || fileList === void 0 ? void 0 : fileList.item(0);
    if (!file) {
      // file removed
      goToFirstStep();
      return;
    }
    dispatch({
      type: 'loadingFile',
      payload: {
        fileName: file.name
      }
    });
    validateFile(file);
  }, [validateFile, goToFirstStep]);
  const onUploadFile = (0, _react.useCallback)(async () => {
    if ((0, _helpers.isValidationStep)(state)) {
      dispatch({
        type: 'uploadingFile'
      });
      try {
        const result = await uploadPrivilegedUserMonitoringFile(state.validatedFile.validLines.text, state.validatedFile.name);
        if (result.stats.failed > 0) {
          dispatch({
            type: 'fileUploadError',
            payload: {
              response: result
            }
          });
        } else {
          onFileUploaded(result.stats.successful);
        }
      } catch (e) {
        dispatch({
          type: 'fileUploadError',
          payload: {
            errorMessage: e.message
          }
        });
      }
    }
  }, [onFileUploaded, state, uploadPrivilegedUserMonitoringFile]);
  const steps = (0, _hooks.useNavigationSteps)(state, goToFirstStep);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !(0, _helpers.isErrorStep)(state) && /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    size: "s",
    steps: steps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 31
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }), (0, _helpers.isFilePickerStep)(state) && /*#__PURE__*/_react.default.createElement(_file_picker_step.PrivilegedUserMonitoringFilePickerStep, {
    onFileChange: onFileChange,
    isLoading: state.isLoading,
    errorMessage: state.fileError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 9
    }
  }), (0, _helpers.isValidationStep)(state) && /*#__PURE__*/_react.default.createElement(_validation_step.PrivilegedUserMonitoringValidationStep, {
    validatedFile: state.validatedFile,
    isLoading: state.isLoading,
    onReturn: goToFirstStep,
    onConfirm: onUploadFile,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 9
    }
  }), (0, _helpers.isErrorStep)(state) && /*#__PURE__*/_react.default.createElement(_error_step.PrivilegedUserMonitoringErrorStep, {
    result: state.fileUploadResponse,
    validLinesAsText: state.validLinesAsText,
    errorMessage: state.fileUploadError,
    goToFirstStep: goToFirstStep,
    onClose: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  }));
};
exports.PrivilegedUsersFileUploader = PrivilegedUsersFileUploader;