"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPrivilegedUsersQuery = void 0;
var _utils = require("../../../../../../common/entity_analytics/privileged_user_monitoring/utils");
var _helpers = require("../../queries/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPrivilegedUsersQuery = (namespace, limit) => {
  return `FROM ${(0, _utils.getPrivilegedMonitorUsersIndex)(namespace)}
  ${(0, _helpers.getPrivilegedMonitorUsersJoin)(namespace)}
  | EVAL
      user.is_privileged = user.is_privileged,
      labels.sources = labels.sources,
      eaLabels = entity_analytics_monitoring.labels.value
  | KEEP user.is_privileged, labels.sources, eaLabels, user.name
  | LIMIT ${limit}
  `;
};
exports.getPrivilegedUsersQuery = getPrivilegedUsersQuery;