"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildPrivilegedUsersTableColumns = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _rison = require("@kbn/rison");
var _securitySolutionDistributionBar = require("@kbn/security-solution-distribution-bar");
var _constants = require("../../../../../detections/containers/detection_engine/alerts/constants");
var _helpers = require("../../../../../common/components/tables/helpers");
var _user_name = require("../../../user_name");
var _empty_value = require("../../../../../common/components/empty_value");
var _utils = require("../../../../common/utils");
var _asset_criticality = require("../../../asset_criticality");
var _use_signal_index = require("../../../../../detections/containers/detection_engine/alerts/use_signal_index");
var _use_alerts_by_status = require("../../../../../overview/components/detection_response/alerts_by_status/use_alerts_by_status");
var _use_global_time = require("../../../../../common/containers/use_global_time");
var _use_query = require("../../../../../detections/containers/detection_engine/alerts/use_query");
var _format_page_filter_search_param = require("../../../../../../common/utils/format_page_filter_search_param");
var _constants2 = require("../../../../../common/hooks/constants");
var _translations = require("../../../../../overview/components/detection_response/translations");
var _types = require("../../../../../../common/types");
var _alert_count_insight = require("../../../../../flyout/document_details/shared/components/alert_count_insight");
var _constants3 = require("../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring/components/privileged_users_table/columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const COLUMN_WIDTHS = {
  actions: '5%',
  '@timestamp': '20%',
  privileged_user: '15%'
};
const getPrivilegedUserColumn = () => ({
  field: 'user.name',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedUsersTable.columns.privilegedUser",
    defaultMessage: "Privileged user",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }),
  width: COLUMN_WIDTHS.privileged_user,
  render: user => user != null ? (0, _helpers.getRowItemsWithActions)({
    values: (0, _fp.isArray)(user) ? user : [user],
    fieldName: 'user.name',
    idPrefix: 'privileged-user-monitoring-privileged-user',
    render: item => /*#__PURE__*/_react.default.createElement(_user_name.UserName, {
      userName: item,
      scopeId: _constants3.SCOPE_ID,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 29
      }
    }),
    displayCount: 1
  }) : (0, _empty_value.getEmptyTagValue)()
});
const getActionsColumn = openUserFlyout => ({
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedUsersTable.columns.actions",
    defaultMessage: "Actions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }),
  render: record => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "expand",
      onClick: () => {
        openUserFlyout(record['user.name']);
      },
      "aria-label": _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedUsersTable.columns.expand.ariaLabel', {
        defaultMessage: 'Open user flyout'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 7
      }
    });
  },
  width: COLUMN_WIDTHS.actions
});
const getRiskScoreColumn = euiTheme => ({
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedUsersTable.columns.riskScore",
    defaultMessage: "Risk score",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  }),
  render: record => {
    const colors = (() => {
      switch (record.risk_level) {
        case 'Unknown':
          return {
            background: euiTheme.colors.backgroundBaseSubdued,
            text: euiTheme.colors.textSubdued
          };
        case 'Low':
          return {
            background: euiTheme.colors.backgroundBaseNeutral,
            text: euiTheme.colors.textNeutral
          };
        case 'Moderate':
          return {
            background: euiTheme.colors.backgroundLightWarning,
            text: euiTheme.colors.textWarning
          };
        case 'High':
          return {
            background: euiTheme.colors.backgroundLightRisk,
            text: euiTheme.colors.textRisk
          };
        case 'Critical':
          return {
            background: euiTheme.colors.backgroundLightDanger,
            text: euiTheme.colors.textDanger
          };
        default:
          return {
            background: euiTheme.colors.backgroundBaseSubdued,
            text: euiTheme.colors.textSubdued
          };
      }
    })();
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: colors.background,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      css: (0, _react2.css)`
            font-weight: ${euiTheme.font.weight.semiBold};
          `,
      size: 's',
      color: colors.text,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 9
      }
    }, record.risk_score ? (0, _utils.formatRiskScoreWholeNumber)(record.risk_score) : _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedUsersTable.columns.riskScore.na', {
      defaultMessage: 'N/A'
    })));
  }
});
const AssetCriticalityCell = ({
  criticalityLevel
}) => {
  return criticalityLevel ? /*#__PURE__*/_react.default.createElement(_asset_criticality.AssetCriticalityBadge, {
    criticalityLevel: criticalityLevel,
    dataTestSubj: "privileged-user-monitoring-asset-criticality-badge",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 5
    }
  }) : (0, _empty_value.getEmptyTagValue)();
};
const getAssetCriticalityColumn = () => ({
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedUsersTable.columns.assetCriticality",
    defaultMessage: "Asset Criticality",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 5
    }
  }),
  render: record => /*#__PURE__*/_react.default.createElement(AssetCriticalityCell, {
    criticalityLevel: record.criticality_level,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 5
    }
  })
});
const getLabelColumn = () => ({
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedUsersTable.columns.label",
    defaultMessage: "Label",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 5
    }
  }),
  render: record => {
    const labels = record.eaLabels;
    return labels ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      "data-test-subj": "privileged-user-monitoring-label",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 7
      }
    }, ((0, _fp.isArray)(labels) ? labels : [labels]).join(', ')) : (0, _empty_value.getEmptyTagValue)();
  }
});
function dataSourcesIsArray(dataSources) {
  return Array.isArray(dataSources);
}
const prettyDataSource = dataSource => {
  return (() => {
    switch (dataSource) {
      case 'csv':
        return _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedUsersTable.columns.dataSource.csv', {
          defaultMessage: 'CSV File'
        });
      case 'index':
        return _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedUsersTable.columns.dataSource.index', {
          defaultMessage: 'Index'
        });
      case 'api':
        return _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedUsersTable.columns.dataSource.api', {
          defaultMessage: 'API request'
        });
      default:
        return dataSource;
    }
  })();
};
const getDataSourceColumn = () => ({
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedUsersTable.columns.dataSource",
    defaultMessage: "Data source",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 5
    }
  }),
  render: record => {
    const dataSources = record['labels.sources'];
    if (!dataSources) return (0, _empty_value.getEmptyTagValue)();
    if (dataSourcesIsArray(dataSources)) return dataSources.map(source => prettyDataSource(source)).join(', ');
    return prettyDataSource(dataSources);
  }
});
const PrivilegedUserAlertDistribution = ({
  userName
}) => {
  var _alertsData$open$tota, _alertsData$open, _alertsData$acknowled, _alertsData$acknowled2;
  const {
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  const {
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    data
  } = (0, _use_query.useQueryAlerts)({
    query: (0, _use_alerts_by_status.getAlertsByStatusQuery)({
      from,
      to,
      entityFilter: {
        field: 'user.name',
        value: userName
      }
    }),
    indexName: signalIndexName,
    queryName: _constants.ALERTS_QUERY_NAMES.BY_STATUS
  });
  const {
    navigateTo
  } = (0, _securitySolutionNavigation.useNavigation)();
  if (!data) return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 21
    }
  });
  const alertsData = (0, _use_alerts_by_status.parseAlertsData)(data);
  const alertStats = (0, _alert_count_insight.getFormattedAlertStats)(alertsData, euiTheme);
  const alertCount = ((_alertsData$open$tota = alertsData === null || alertsData === void 0 ? void 0 : (_alertsData$open = alertsData.open) === null || _alertsData$open === void 0 ? void 0 : _alertsData$open.total) !== null && _alertsData$open$tota !== void 0 ? _alertsData$open$tota : 0) + ((_alertsData$acknowled = alertsData === null || alertsData === void 0 ? void 0 : (_alertsData$acknowled2 = alertsData.acknowledged) === null || _alertsData$acknowled2 === void 0 ? void 0 : _alertsData$acknowled2.total) !== null && _alertsData$acknowled !== void 0 ? _alertsData$acknowled : 0);
  const timerange = (0, _rison.encode)({
    global: {
      [_constants2.URL_PARAM_KEY.timerange]: {
        kind: 'absolute',
        from,
        to
      }
    }
  });
  const filters = [{
    title: _translations.OPEN_IN_ALERTS_TITLE_USERNAME,
    selectedOptions: [userName],
    fieldName: 'user.name'
  }, {
    title: _translations.OPEN_IN_ALERTS_TITLE_STATUS,
    selectedOptions: [_types.FILTER_OPEN, _types.FILTER_ACKNOWLEDGED],
    fieldName: 'kibana.alert.workflow_status'
  }];
  const urlFilterParams = (0, _rison.encode)((0, _format_page_filter_search_param.formatPageFilterSearchParam)(filters));
  const timerangePath = timerange ? `&timerange=${timerange}` : '';
  const openAlertsPage = () => {
    navigateTo({
      deepLinkId: _securitySolutionNavigation.SecurityPageName.alerts,
      path: `?${_constants2.URL_PARAM_KEY.pageFilter}=${urlFilterParams}${timerangePath}`,
      openInNewTab: true
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_securitySolutionDistributionBar.DistributionBar, {
    stats: alertStats,
    hideLastTooltip: true,
    "data-test-subj": `privileged-users-alerts-distribution-bar`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: openAlertsPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 33
    }
  }, alertCount)));
};
const getAlertDistributionColumn = () => ({
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedUsersTable.columns.alerts",
    defaultMessage: "Alerts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 5
    }
  }),
  render: record => {
    return /*#__PURE__*/_react.default.createElement(PrivilegedUserAlertDistribution, {
      userName: record['user.name'],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 335,
        columnNumber: 12
      }
    });
  }
});
const buildPrivilegedUsersTableColumns = (openUserFlyout, euiTheme) => [getActionsColumn(openUserFlyout), getPrivilegedUserColumn(), getRiskScoreColumn(euiTheme), getAssetCriticalityColumn(), getLabelColumn(), getDataSourceColumn(), getAlertDistributionColumn()];
exports.buildPrivilegedUsersTableColumns = buildPrivilegedUsersTableColumns;