"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_ALL_USERS_ANOMALIES = exports.VIEW_ALL_HOSTS_ANOMALIES = exports.VIEW_ALL_ANOMALIES = exports.RUN_JOB = exports.MODULE_NOT_COMPATIBLE_TITLE = exports.JOB_STATUS_WAITING = exports.JOB_STATUS_UNINSTALLED = exports.JOB_STATUS_FAILED = exports.JOB_STATUS_DISABLED = exports.ANOMALY_NAME = exports.ANOMALY_DETECTION_DOCS = exports.ANOMALY_COUNT = exports.ANOMALIES_TOOLTIP = exports.ANOMALIES_TITLE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ANOMALIES_TITLE = exports.ANOMALIES_TITLE = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.anomaliesTitle', {
  defaultMessage: 'Anomalies'
});
const ANOMALY_NAME = exports.ANOMALY_NAME = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.anomalyName', {
  defaultMessage: 'Anomaly name'
});
const ANOMALY_COUNT = exports.ANOMALY_COUNT = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.anomalyCount', {
  defaultMessage: 'Count'
});
const VIEW_ALL_USERS_ANOMALIES = exports.VIEW_ALL_USERS_ANOMALIES = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.viewUsersAnomalies', {
  defaultMessage: 'View all user anomalies'
});
const VIEW_ALL_HOSTS_ANOMALIES = exports.VIEW_ALL_HOSTS_ANOMALIES = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.viewHostsAnomalies', {
  defaultMessage: 'View all host anomalies'
});
const VIEW_ALL_ANOMALIES = exports.VIEW_ALL_ANOMALIES = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.viewAnomalies', {
  defaultMessage: 'View all'
});
const RUN_JOB = exports.RUN_JOB = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.enableJob', {
  defaultMessage: 'Run job'
});
const JOB_STATUS_DISABLED = exports.JOB_STATUS_DISABLED = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.jobStatusDisabled', {
  defaultMessage: 'disabled'
});
const JOB_STATUS_UNINSTALLED = exports.JOB_STATUS_UNINSTALLED = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.jobStatusUninstalled', {
  defaultMessage: 'uninstalled'
});
const JOB_STATUS_FAILED = exports.JOB_STATUS_FAILED = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.jobStatusFailed', {
  defaultMessage: 'failed'
});
const JOB_STATUS_WAITING = exports.JOB_STATUS_WAITING = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.jobStatusLoading', {
  defaultMessage: 'Waiting'
});
const MODULE_NOT_COMPATIBLE_TITLE = incompatibleJobCount => _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.moduleNotCompatibleTitle', {
  values: {
    incompatibleJobCount
  },
  defaultMessage: '{incompatibleJobCount} {incompatibleJobCount, plural, =1 {job is} other {jobs are}} currently unavailable'
});
exports.MODULE_NOT_COMPATIBLE_TITLE = MODULE_NOT_COMPATIBLE_TITLE;
const ANOMALY_DETECTION_DOCS = exports.ANOMALY_DETECTION_DOCS = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.AnomalyDetectionDocsTitle', {
  defaultMessage: 'Anomaly Detection with Machine Learning'
});
const ANOMALIES_TOOLTIP = exports.ANOMALIES_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.anomaliesTooltip', {
  defaultMessage: 'The anomalies table is not filterable via the SIEM global KQL search.'
});