"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEntityStoreRoutes = void 0;
var _react = require("react");
var _constants = require("../../../common/entity_analytics/constants");
var _kibana_react = require("../../common/lib/kibana/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEntityStoreRoutes = () => {
  const http = (0, _kibana_react.useKibana)().services.http;
  return (0, _react.useMemo)(() => {
    const enableEntityStore = async (options = {}) => {
      return http.fetch('/api/entity_store/enable', {
        method: 'POST',
        version: _constants.API_VERSIONS.public.v1,
        body: JSON.stringify(options)
      });
    };
    const getEntityStoreStatus = async (withComponents = false) => {
      return http.fetch('/api/entity_store/status', {
        method: 'GET',
        version: _constants.API_VERSIONS.public.v1,
        query: {
          include_components: withComponents
        }
      });
    };
    const initEntityEngine = async entityType => {
      return http.fetch(`/api/entity_store/engines/${entityType}/init`, {
        method: 'POST',
        version: _constants.API_VERSIONS.public.v1,
        body: JSON.stringify({})
      });
    };
    const stopEntityEngine = async entityType => {
      return http.fetch(`/api/entity_store/engines/${entityType}/stop`, {
        method: 'POST',
        version: _constants.API_VERSIONS.public.v1,
        body: JSON.stringify({})
      });
    };
    const deleteEntityEngine = async (entityType, deleteData) => {
      return http.fetch(`/api/entity_store/engines/${entityType}`, {
        method: 'DELETE',
        query: {
          data: deleteData
        },
        version: _constants.API_VERSIONS.public.v1
      });
    };
    const listEntityEngines = async () => {
      return http.fetch(`/api/entity_store/engines`, {
        method: 'GET',
        version: _constants.API_VERSIONS.public.v1
      });
    };
    return {
      enableEntityStore,
      getEntityStoreStatus,
      initEntityEngine,
      stopEntityEngine,
      deleteEntityEngine,
      listEntityEngines
    };
  }, [http]);
};
exports.useEntityStoreRoutes = useEntityStoreRoutes;