"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useListsConfig = void 0;
var _react = require("react");
var _kibana = require("../../../../common/lib/kibana");
var _use_lists_index = require("./use_lists_index");
var _use_lists_privileges = require("./use_lists_privileges");
var _user_privileges = require("../../../../common/components/user_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useListsConfig = () => {
  var _detectionEnginePrivi, _detectionEnginePrivi2;
  const {
    createIndex,
    indexExists,
    loading: indexLoading,
    error: indexError
  } = (0, _use_lists_index.useListsIndex)();
  const {
    canManageIndex,
    canWriteIndex,
    loading: privilegesLoading
  } = (0, _use_lists_privileges.useListsPrivileges)();
  const {
    detectionEnginePrivileges
  } = (0, _user_privileges.useUserPrivileges)();
  const {
    lists
  } = (0, _kibana.useKibana)().services;
  const canManageCluster = (_detectionEnginePrivi = (_detectionEnginePrivi2 = detectionEnginePrivileges.result) === null || _detectionEnginePrivi2 === void 0 ? void 0 : _detectionEnginePrivi2.cluster.manage) !== null && _detectionEnginePrivi !== void 0 ? _detectionEnginePrivi : null;
  const enabled = lists != null;
  const loading = indexLoading || privilegesLoading;
  const needsIndex = indexExists === false;
  const hasIndexError = indexError != null;
  const needsIndexConfiguration = needsIndex && (canManageIndex === false || canManageIndex === true && hasIndexError);
  const needsConfiguration = !enabled || needsIndexConfiguration;
  // Index can be created only when manage cluster privilege assigned to user role.
  // It's needed to create index templates
  const canCreateIndex = canManageIndex && canManageCluster;
  (0, _react.useEffect)(() => {
    if (needsIndex && canCreateIndex && !indexLoading) {
      createIndex();
    }
  }, [createIndex, needsIndex, canCreateIndex, indexLoading]);
  return {
    canManageIndex,
    canWriteIndex,
    enabled,
    loading,
    needsConfiguration,
    needsIndex,
    canCreateIndex
  };
};
exports.useListsConfig = useListsConfig;