"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldFinalReadOnly = FieldFinalReadOnly;
var _react = _interopRequireWildcard(require("react"));
var _detection_engine = require("../../../../../../../common/api/detection_engine");
var _utility_types = require("../../../../../../../common/utility_types");
var _field_upgrade_context = require("../rule_upgrade/field_upgrade_context");
var _custom_query_rule_field_readonly = require("./custom_query_rule_field_readonly");
var _saved_query_rule_field_readonly = require("./saved_query_rule_field_readonly");
var _eql_rule_field_readonly = require("./eql_rule_field_readonly");
var _esql_rule_field_readonly = require("./esql_rule_field_readonly");
var _threat_match_rule_field_readonly = require("./threat_match_rule_field_readonly");
var _threshold_rule_field_readonly = require("./threshold_rule_field_readonly");
var _machine_learning_rule_field_readonly = require("./machine_learning_rule_field_readonly");
var _new_terms_rule_field_readonly = require("./new_terms_rule_field_readonly");
var _common_rule_field_readonly = require("./common_rule_field_readonly");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_readonly/field_final_readonly.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FieldFinalReadOnly() {
  const {
    fieldName,
    finalDiffableRule
  } = (0, _field_upgrade_context.useFieldUpgradeContext)();
  const {
    data: commonField
  } = (0, _react.useMemo)(() => _detection_engine.DiffableCommonFields.keyof().safeParse(fieldName), [fieldName]);
  if (commonField) {
    return /*#__PURE__*/_react.default.createElement(_common_rule_field_readonly.CommonRuleFieldReadOnly, {
      fieldName: commonField,
      finalDiffableRule: finalDiffableRule,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 7
      }
    });
  }
  switch (finalDiffableRule.type) {
    case 'query':
      return /*#__PURE__*/_react.default.createElement(_custom_query_rule_field_readonly.CustomQueryRuleFieldReadOnly, {
        fieldName: fieldName,
        finalDiffableRule: finalDiffableRule,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 9
        }
      });
    case 'saved_query':
      return /*#__PURE__*/_react.default.createElement(_saved_query_rule_field_readonly.SavedQueryRuleFieldReadOnly, {
        fieldName: fieldName,
        finalDiffableRule: finalDiffableRule,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 9
        }
      });
    case 'eql':
      return /*#__PURE__*/_react.default.createElement(_eql_rule_field_readonly.EqlRuleFieldReadOnly, {
        fieldName: fieldName,
        finalDiffableRule: finalDiffableRule,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 9
        }
      });
    case 'esql':
      return /*#__PURE__*/_react.default.createElement(_esql_rule_field_readonly.EsqlRuleFieldReadOnly, {
        fieldName: fieldName,
        finalDiffableRule: finalDiffableRule,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 9
        }
      });
    case 'threat_match':
      return /*#__PURE__*/_react.default.createElement(_threat_match_rule_field_readonly.ThreatMatchRuleFieldReadOnly, {
        fieldName: fieldName,
        finalDiffableRule: finalDiffableRule,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 9
        }
      });
    case 'threshold':
      return /*#__PURE__*/_react.default.createElement(_threshold_rule_field_readonly.ThresholdRuleFieldReadOnly, {
        fieldName: fieldName,
        finalDiffableRule: finalDiffableRule,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 9
        }
      });
    case 'machine_learning':
      return /*#__PURE__*/_react.default.createElement(_machine_learning_rule_field_readonly.MachineLearningRuleFieldReadOnly, {
        fieldName: fieldName,
        finalDiffableRule: finalDiffableRule,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 9
        }
      });
    case 'new_terms':
      return /*#__PURE__*/_react.default.createElement(_new_terms_rule_field_readonly.NewTermsRuleFieldReadOnly, {
        fieldName: fieldName,
        finalDiffableRule: finalDiffableRule,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 9
        }
      });
    default:
      return (0, _utility_types.assertUnreachable)(finalDiffableRule);
  }
}