"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsAddToRulesOptions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _add_to_rules_table = require("../add_to_rules_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_exceptions/components/flyout_components/add_to_rules_options/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExceptionsAddToRulesOptionsComponent = ({
  possibleRules,
  isSingleRule,
  isBulkAction,
  selectedRadioOption,
  onRuleSelectionChange,
  onRadioChange
}) => {
  const ruleRadioOptionProps = (0, _react.useMemo)(() => {
    if (isBulkAction && possibleRules != null) {
      return {
        id: 'add_to_rules',
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          "data-test-subj": "addToRulesRadioOption",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 39,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          defaultMessage: "Add to [{numRules}] selected rules: {ruleNames}",
          id: "xpack.securitySolution.exceptions.common.addToRulesOptionLabel",
          values: {
            numRules: possibleRules.length,
            ruleNames: /*#__PURE__*/_react.default.createElement("span", {
              css: {
                fontWeight: 'bold'
              },
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 46,
                columnNumber: 19
              }
            }, possibleRules.map(({
              name
            }) => name).join(','))
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 40,
            columnNumber: 13
          }
        })),
        checked: selectedRadioOption === 'add_to_rules',
        'data-test-subj': 'addToRulesOptionsRadio',
        onChange: () => {
          onRadioChange('add_to_rules');
          onRuleSelectionChange(possibleRules);
        }
      };
    }
    if (isSingleRule && possibleRules != null) {
      return {
        id: 'add_to_rule',
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          "data-test-subj": "addToRuleRadioOption",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 67,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          defaultMessage: "Add to this rule: {ruleName}",
          id: "xpack.securitySolution.exceptions.common.addToRuleOptionLabel",
          values: {
            ruleName: /*#__PURE__*/_react.default.createElement("span", {
              css: {
                fontWeight: 'bold'
              },
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 72,
                columnNumber: 27
              }
            }, possibleRules[0].name)
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 68,
            columnNumber: 13
          }
        })),
        checked: selectedRadioOption === 'add_to_rule',
        'data-test-subj': 'addToRuleOptionsRadio',
        onChange: () => {
          onRadioChange('add_to_rule');
          onRuleSelectionChange(possibleRules);
        }
      };
    }
    return {
      id: 'select_rules_to_add_to',
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        "data-test-subj": "selectRulesToAddToRadioOption",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        defaultMessage: "Add to rules",
        id: "xpack.securitySolution.exceptions.common.selectRulesOptionLabel",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 11
        }
      })),
      checked: selectedRadioOption === 'select_rules_to_add_to',
      'data-test-subj': 'selectRulesToAddToOptionRadio',
      onChange: () => onRadioChange('select_rules_to_add_to')
    };
  }, [isBulkAction, possibleRules, isSingleRule, selectedRadioOption, onRadioChange, onRuleSelectionChange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, (0, _extends2.default)({
    name: "addToRulesOption"
  }, ruleRadioOptionProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  })), selectedRadioOption === 'select_rules_to_add_to' && /*#__PURE__*/_react.default.createElement(_add_to_rules_table.ExceptionsAddToRulesTable, {
    onRuleSelectionChange: onRuleSelectionChange,
    initiallySelectedRules: [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }));
};
const ExceptionsAddToRulesOptions = exports.ExceptionsAddToRulesOptions = /*#__PURE__*/_react.default.memo(ExceptionsAddToRulesOptionsComponent);
ExceptionsAddToRulesOptions.displayName = 'ExceptionsAddToRulesOptions';