"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AiAssistant = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _react2 = require("@emotion/react");
var _telemetry = require("../../../../common/lib/telemetry");
var _use_assistant_availability = require("../../../../assistant/use_assistant_availability");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/ai_assistant/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getLanguageName = language => {
  let modifiedLanguage = language;
  if (language === 'eql') {
    modifiedLanguage = 'EQL(Event Query Language)';
  }
  if (language === 'esql') {
    modifiedLanguage = 'ES|QL(The Elasticsearch Query Language)';
  }
  return modifiedLanguage;
};
const retrieveErrorMessages = errors => errors.flatMap(({
  message,
  messages
}) => [message, ...(Array.isArray(messages) ? messages : [])]).join(', ');
const AiAssistantComponent = ({
  getFields,
  setFieldValue,
  language
}) => {
  const {
    hasAssistantPrivilege,
    isAssistantEnabled
  } = (0, _use_assistant_availability.useAssistantAvailability)();
  const languageName = getLanguageName(language);
  const getPromptContext = (0, _react.useCallback)(async () => {
    const queryField = getFields().queryBar;
    const {
      query
    } = queryField.value.query;
    if (!query) {
      return '';
    }
    if (queryField.errors.length === 0) {
      return `No errors in ${languageName} language query detected. Current query: ${query.trim()}`;
    }
    return `${languageName} language query written for Elastic Security Detection rules: \"${query.trim()}\"
returns validation error on form: \"${retrieveErrorMessages(queryField.errors)}\"
Fix ${languageName} language query and give an example of it in markdown format that can be copied.
Proposed solution should be valid and must not contain new line symbols (\\n)`;
  }, [getFields, languageName]);
  const onShowOverlay = (0, _react.useCallback)(() => {
    (0, _telemetry.track)(_telemetry.METRIC_TYPE.COUNT, _telemetry.TELEMETRY_EVENT.OPEN_ASSISTANT_ON_RULE_QUERY_ERROR);
  }, []);
  const handleOnExportCodeBlock = (0, _react.useCallback)(codeBlock => {
    const queryField = getFields().queryBar;
    const queryBar = queryField.value;

    // sometimes AI assistant include redundant backtick symbols in code block
    const newQuery = codeBlock.replaceAll('`', '');
    if (queryBar.query.query !== newQuery) {
      setFieldValue('queryBar', {
        ...queryBar,
        query: {
          ...queryBar.query,
          query: newQuery
        }
      });
    }
  }, [getFields, setFieldValue]);
  const chatTitle = (0, _react.useMemo)(() => {
    const queryField = getFields().queryBar;
    const {
      query
    } = queryField.value.query;
    return `${i18n.DETECTION_RULES_CREATE_FORM_CONVERSATION_ID} - ${query !== null && query !== void 0 ? query : 'query'}`;
  }, [getFields]);
  if (!hasAssistantPrivilege) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.createRule.stepDefineRule.askAssistantHelpText",
    defaultMessage: "{AiAssistantNewChatLink} to help resolve this error.",
    values: {
      AiAssistantNewChatLink: /*#__PURE__*/_react.default.createElement(_elasticAssistant.NewChat, {
        asLink: true,
        category: "detection-rules",
        conversationTitle: chatTitle,
        description: i18n.ASK_ASSISTANT_DESCRIPTION,
        getPromptContext: getPromptContext,
        suggestedUserPrompt: i18n.ASK_ASSISTANT_USER_PROMPT(languageName),
        tooltip: i18n.ASK_ASSISTANT_TOOLTIP,
        iconType: null,
        onShowOverlay: onShowOverlay,
        isAssistantEnabled: isAssistantEnabled,
        onExportCodeBlock: handleOnExportCodeBlock,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_aiAssistantIcon.AssistantIcon, {
        size: "s",
        css: (0, _react2.css)`
                  vertical-align: inherit;
                `,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 15
        }
      }), i18n.ASK_ASSISTANT_ERROR_BUTTON)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }));
};
const AiAssistant = exports.AiAssistant = /*#__PURE__*/_react.default.memo(AiAssistantComponent);
AiAssistant.displayName = 'AiAssistant';